/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.util.Stack;
import org.gjt.sp.jedit.JEditAbstractEditAction;
import org.gjt.sp.jedit.JEditActionSet;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

class ActionListHandler
extends DefaultHandler {
    private String path;
    private JEditActionSet actionSet;
    private String actionName;
    private final StringBuilder code;
    private final StringBuilder isSelected;
    private boolean noRepeat;
    private boolean noRecord;
    private boolean noRememberLast;
    private final Stack<String> stateStack;

    ActionListHandler(String path, JEditActionSet actionSet) {
        this.path = path;
        this.actionSet = actionSet;
        this.stateStack = new Stack();
        this.code = new StringBuilder();
        this.isSelected = new StringBuilder();
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        return XMLUtilities.findEntity(systemId, "actions.dtd", this.getClass());
    }

    public void attribute(String aname, String value, boolean isSpecified) {
        aname = aname == null ? null : aname.intern();
        String string = value = value == null ? null : value.intern();
        if (aname == "NAME") {
            this.actionName = value;
        } else if (aname == "NO_REPEAT") {
            this.noRepeat = value == "TRUE";
        } else if (aname == "NO_RECORD") {
            this.noRecord = value == "TRUE";
        } else if (aname == "NO_REMEMBER_LAST") {
            this.noRememberLast = value == "TRUE";
        }
    }

    @Override
    public void characters(char[] c, int off, int len) {
        String tag = this.peekElement();
        if (tag.equals("CODE")) {
            this.code.append(c, off, len);
        } else if (tag.equals("IS_SELECTED")) {
            this.isSelected.append(c, off, len);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        String tag = this.pushElement(qName);
        if (tag.equals("ACTION")) {
            this.actionName = attrs.getValue("NAME");
            this.noRepeat = "TRUE".equals(attrs.getValue("NO_REPEAT"));
            this.noRecord = "TRUE".equals(attrs.getValue("NO_RECORD"));
            this.noRememberLast = "TRUE".equals(attrs.getValue("NO_REMEMBER_LAST"));
            this.code.setLength(0);
            this.isSelected.setLength(0);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        String tag = this.peekElement();
        if (qName.equals(tag)) {
            if (tag.equals("ACTION")) {
                String selected = this.isSelected.length() > 0 ? this.isSelected.toString() : null;
                JEditAbstractEditAction action = this.actionSet.createBeanShellAction(this.actionName, this.code.toString(), selected, this.noRepeat, this.noRecord, this.noRememberLast);
                this.actionSet.addAction(action);
                this.noRememberLast = false;
                this.noRecord = false;
                this.noRepeat = false;
                this.code.setLength(0);
                this.isSelected.setLength(0);
            }
        } else {
            throw new InternalError();
        }
        this.popElement();
    }

    @Override
    public void startDocument() {
        try {
            this.pushElement(null);
        }
        catch (Exception e) {
            Log.log(9, this, e);
        }
    }

    private String pushElement(String name) {
        name = name == null ? null : name.intern();
        this.stateStack.push(name);
        return name;
    }

    private String peekElement() {
        return this.stateStack.peek();
    }

    private String popElement() {
        return this.stateStack.pop();
    }
}

