/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.buffer;

import java.util.Collection;
import javax.swing.event.ListDataListener;
import org.gjt.sp.jedit.gui.MutableListModel;

public class KillRing
implements MutableListModel {
    private String[] ring;
    private int count;
    private boolean wrap;
    private static KillRing killRing = new KillRing();

    public static KillRing getInstance() {
        return killRing;
    }

    public static void setInstance(KillRing killRing) {
        KillRing.killRing = killRing;
    }

    public void propertiesChanged(int historySize) {
        int newSize = Math.max(1, historySize);
        if (this.ring == null) {
            this.ring = new String[newSize];
        } else if (newSize != this.ring.length) {
            String[] newRing = new String[newSize];
            int newCount = Math.min(this.getSize(), newSize);
            for (int i = 0; i < newCount; ++i) {
                newRing[i] = (String)this.getElementAt(i);
            }
            this.ring = newRing;
            this.count = newCount;
            this.wrap = false;
        }
        if (this.count == this.ring.length) {
            this.count = 0;
            this.wrap = true;
        }
    }

    public void load() {
    }

    public void save() {
    }

    protected void reset(Collection<?> source) {
        String[] newRing = new String[source.size()];
        int i = 0;
        for (Object x : source) {
            newRing[i++] = (String)x;
        }
        this.ring = newRing;
        this.count = 0;
        this.wrap = true;
    }

    @Override
    public void addListDataListener(ListDataListener listener) {
    }

    @Override
    public void removeListDataListener(ListDataListener listener) {
    }

    public Object getElementAt(int index) {
        return this.ring[this.virtualToPhysicalIndex(index)];
    }

    @Override
    public int getSize() {
        if (this.wrap) {
            return this.ring.length;
        }
        return this.count;
    }

    @Override
    public boolean removeElement(Object value) {
        for (int i = 0; i < this.getSize(); ++i) {
            if (!this.ring[i].equals(value)) continue;
            this.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public void insertElementAt(Object value, int index) {
        this.remove(index);
        this.add((String)value);
    }

    void changed(String oldStr, String newStr) {
        int i = this.indexOf(oldStr);
        if (i != -1) {
            this.ring[i] = newStr;
        } else {
            this.add(newStr);
        }
    }

    void add(String removed) {
        if (this.indexOf(removed) != -1) {
            return;
        }
        boolean allWhitespace = true;
        for (int i = 0; i < removed.length(); ++i) {
            if (Character.isWhitespace(removed.charAt(i))) continue;
            allWhitespace = false;
            break;
        }
        if (allWhitespace) {
            return;
        }
        this.ring[this.count] = removed;
        if (++this.count >= this.ring.length) {
            this.wrap = true;
            this.count = 0;
        }
    }

    void remove(int i) {
        if (this.wrap) {
            String[] newRing = new String[this.ring.length];
            int newCount = 0;
            for (int j = 0; j < this.ring.length; ++j) {
                int index = this.virtualToPhysicalIndex(j);
                if (i == index) continue;
                newRing[newCount++] = this.ring[index];
            }
            this.ring = newRing;
            this.count = newCount;
            this.wrap = false;
        } else {
            System.arraycopy(this.ring, i + 1, this.ring, i, this.count - i - 1);
            --this.count;
        }
    }

    private int virtualToPhysicalIndex(int index) {
        if (this.wrap) {
            if (index < this.count) {
                return this.count - index - 1;
            }
            return this.count + this.ring.length - index - 1;
        }
        return this.count - index - 1;
    }

    private int indexOf(String str) {
        int length = this.wrap ? this.ring.length : this.count;
        for (int i = length - 1; i >= 0; --i) {
            if (!this.ring[i].equals(str)) continue;
            return i;
        }
        return -1;
    }
}

