/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gjt.sp.jedit.datatransfer.JEditTransferable;
import org.gjt.sp.jedit.datatransfer.JEditTransferableService;
import org.gjt.sp.jedit.textarea.TextArea;

public class TransferHandler {
    private static final TransferHandler instance = new TransferHandler();
    private final List<JEditTransferableService> services = new ArrayList<JEditTransferableService>();

    private TransferHandler() {
    }

    public static TransferHandler getInstance() {
        return instance;
    }

    public void registerTransferableService(JEditTransferableService transferableService) {
        if (!this.services.contains(transferableService)) {
            this.services.add(transferableService);
        }
    }

    public Transferable getTransferable(TextArea textArea, String text) {
        HashMap<DataFlavor, Transferable> flavors = new HashMap<DataFlavor, Transferable>();
        for (JEditTransferableService service : this.services) {
            DataFlavor[] supportedDataFlavor;
            if (!service.accept(textArea, text)) continue;
            Transferable t = service.getTransferable(textArea, text);
            for (DataFlavor dataFlavor : supportedDataFlavor = t.getTransferDataFlavors()) {
                flavors.put(dataFlavor, t);
            }
        }
        JEditTransferable transferable = new JEditTransferable(flavors);
        return transferable;
    }
}

