/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.AbstractContextOptionPane;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;

public class ContextAddDialog
extends EnhancedDialog {
    private static final String CONTEXT_ADD_DIALOG_LAST_SELECTION = "contextAddDialog.lastSelection";
    private boolean isOK;
    private final JRadioButton separator;
    private final JRadioButton action;
    private final JComboBox combo;
    private final JList list;
    private final JButton ok;
    private final JButton cancel;

    public ContextAddDialog(Component comp, ActionContext actionContext) {
        super(GUIUtilities.getParentDialog(comp), jEdit.getProperty("options.context.add.title"), true);
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        ActionHandler actionHandler = new ActionHandler();
        ButtonGroup grp = new ButtonGroup();
        JPanel typePanel = new JPanel(new GridLayout(3, 1, 6, 6));
        typePanel.setBorder(new EmptyBorder(0, 0, 6, 0));
        typePanel.add(new JLabel(jEdit.getProperty("options.context.add.caption")));
        this.separator = new JRadioButton(jEdit.getProperty("options.context.add.separator"));
        this.separator.addActionListener(actionHandler);
        grp.add(this.separator);
        typePanel.add(this.separator);
        this.action = new JRadioButton(jEdit.getProperty("options.context.add.action"));
        this.action.addActionListener(actionHandler);
        grp.add(this.action);
        this.action.setSelected(true);
        typePanel.add(this.action);
        content.add("North", typePanel);
        JPanel actionPanel = new JPanel(new BorderLayout(6, 6));
        ActionSet[] actionsList = (ActionSet[])actionContext.getActionSets();
        TreeSet<ActionSet> actionSets = new TreeSet<ActionSet>();
        String lastSelectionLabel = jEdit.getProperty(CONTEXT_ADD_DIALOG_LAST_SELECTION);
        for (ActionSet actionSet : actionsList) {
            if (actionSet.getActionCount() == 0) continue;
            actionSets.add(actionSet);
        }
        int selectionIndex = 0;
        int i = 0;
        for (ActionSet actionSet : actionSets) {
            if (actionSet.getLabel().equals(lastSelectionLabel)) {
                selectionIndex = i;
                break;
            }
            ++i;
        }
        this.combo = new JComboBox<Object>(actionSets.toArray());
        this.combo.setSelectedIndex(selectionIndex);
        this.combo.addActionListener(actionHandler);
        actionPanel.add("North", this.combo);
        this.list = new JList();
        this.list.setVisibleRowCount(8);
        this.list.setSelectionMode(0);
        actionPanel.add("Center", new JScrollPane(this.list));
        content.add("Center", actionPanel);
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new BoxLayout(southPanel, 0));
        southPanel.setBorder(new EmptyBorder(12, 0, 0, 0));
        southPanel.add(Box.createGlue());
        this.ok = new JButton(jEdit.getProperty("common.ok"));
        this.ok.addActionListener(actionHandler);
        this.getRootPane().setDefaultButton(this.ok);
        southPanel.add(this.ok);
        southPanel.add(Box.createHorizontalStrut(6));
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.cancel.addActionListener(actionHandler);
        southPanel.add(this.cancel);
        southPanel.add(Box.createGlue());
        content.add("South", southPanel);
        this.updateList();
        this.pack();
        this.setLocationRelativeTo(GUIUtilities.getParentDialog(comp));
        this.setVisible(true);
    }

    @Override
    public void ok() {
        this.isOK = true;
        this.dispose();
    }

    @Override
    public void cancel() {
        this.dispose();
    }

    public String getSelection() {
        if (!this.isOK) {
            return null;
        }
        if (this.separator.isSelected()) {
            return "-";
        }
        if (this.action.isSelected()) {
            AbstractContextOptionPane.MenuItem selectedValue = (AbstractContextOptionPane.MenuItem)this.list.getSelectedValue();
            return selectedValue == null ? null : selectedValue.actionName;
        }
        throw new InternalError();
    }

    private void updateList() {
        ActionSet actionSet = (ActionSet)this.combo.getSelectedItem();
        jEdit.setProperty(CONTEXT_ADD_DIALOG_LAST_SELECTION, actionSet.getLabel());
        EditAction[] actions = actionSet.getActions();
        Vector<AbstractContextOptionPane.MenuItem> listModel = new Vector<AbstractContextOptionPane.MenuItem>(actions.length);
        for (int i = 0; i < actions.length; ++i) {
            EditAction action = actions[i];
            String label = action.getLabel();
            if (label == null) continue;
            listModel.addElement(new AbstractContextOptionPane.MenuItem(action.getName(), label));
        }
        Collections.sort(listModel, new AbstractContextOptionPane.MenuItemCompare());
        this.list.setListData(listModel);
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source instanceof JRadioButton) {
                ContextAddDialog.this.combo.setEnabled(ContextAddDialog.this.action.isSelected());
                ContextAddDialog.this.list.setEnabled(ContextAddDialog.this.action.isSelected());
            }
            if (source == ContextAddDialog.this.ok) {
                ContextAddDialog.this.ok();
            } else if (source == ContextAddDialog.this.cancel) {
                ContextAddDialog.this.cancel();
            } else if (source == ContextAddDialog.this.combo) {
                ContextAddDialog.this.updateList();
            }
        }
    }
}

