/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.CardLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.gjt.sp.jedit.gui.DockableWindowManagerImpl;
import org.gjt.sp.jedit.gui.PanelWindowContainer;

class DockablePanel
extends JPanel {
    private PanelWindowContainer panel;
    private DockableWindowManagerImpl wm;
    static Point dragStart;

    DockablePanel(PanelWindowContainer panel) {
        super(new CardLayout());
        this.panel = panel;
        this.wm = panel.getDockableWindowManager();
        ResizeMouseHandler resizeMouseHandler = new ResizeMouseHandler();
        this.addMouseListener(resizeMouseHandler);
        this.addMouseMotionListener(resizeMouseHandler);
    }

    PanelWindowContainer getWindowContainer() {
        return this.panel;
    }

    void showDockable(String name) {
        ((CardLayout)this.getLayout()).show(this, name);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getPreferredSize() {
        String position = this.panel.getPosition();
        int dimension = this.panel.getDimension();
        if (this.panel.getCurrent() == null) {
            return new Dimension(0, 0);
        }
        if (position.equals("top") || position.equals("bottom")) {
            if (dimension <= 0) {
                int height = super.getPreferredSize().height;
                this.panel.setDimension(height);
            }
            return new Dimension(0, dimension + 10);
        }
        if (dimension <= 0) {
            int width = super.getPreferredSize().width;
            this.panel.setDimension(width);
        }
        return new Dimension(dimension + 10, 0);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        String position = this.panel.getPosition();
        int dimension = this.panel.getDimension();
        if (position.equals("top") || position.equals("bottom")) {
            if (dimension != 0 && height <= 10) {
                this.panel.show((DockableWindowManagerImpl.Entry)null);
            } else {
                this.panel.setDimension(height);
            }
        } else if (dimension != 0 && width <= 10) {
            this.panel.show((DockableWindowManagerImpl.Entry)null);
        } else {
            this.panel.setDimension(width);
        }
        super.setBounds(x, y, width, height);
    }

    class ResizeMouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        boolean canDrag;
        private boolean continuousLayout;

        ResizeMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (this.canDrag) {
                this.continuousLayout = UIManager.getBoolean("SplitPane.continuousLayout");
                DockablePanel.this.wm.setResizePos(DockablePanel.this.panel.getDimension(), DockablePanel.this.panel);
                dragStart = evt.getPoint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (this.canDrag) {
                if (!this.continuousLayout) {
                    DockablePanel.this.panel.setDimension(((DockablePanel)DockablePanel.this).wm.resizePos + 10);
                }
                DockablePanel.this.wm.finishResizing();
                dragStart = null;
                DockablePanel.this.wm.revalidate();
            }
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
            Border border = DockablePanel.this.getBorder();
            if (border == null) {
                return;
            }
            String position = DockablePanel.this.panel.getPosition();
            Insets insets = border.getBorderInsets(DockablePanel.this);
            this.canDrag = false;
            if (position.equals("top")) {
                if (evt.getY() >= DockablePanel.this.getHeight() - insets.bottom) {
                    this.canDrag = true;
                }
            } else if (position.equals("left")) {
                if (evt.getX() >= DockablePanel.this.getWidth() - insets.right) {
                    this.canDrag = true;
                }
            } else if (position.equals("bottom")) {
                if (evt.getY() <= insets.top) {
                    this.canDrag = true;
                }
            } else if (position.equals("right") && evt.getX() <= insets.left) {
                this.canDrag = true;
            }
            if (dragStart == null) {
                if (this.canDrag) {
                    DockablePanel.this.wm.setCursor(Cursor.getPredefinedCursor(this.getAppropriateCursor()));
                } else {
                    DockablePanel.this.wm.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            if (!this.canDrag) {
                return;
            }
            if (dragStart == null) {
                return;
            }
            int dimension = DockablePanel.this.panel.getDimension();
            String position = DockablePanel.this.panel.getPosition();
            int newSize = 0;
            if (position.equals("top")) {
                newSize = evt.getY();
                DockablePanel.this.wm.setResizePos(evt.getY() - DockablePanel.dragStart.y + dimension, DockablePanel.this.panel);
            } else if (position.equals("left")) {
                newSize = evt.getX();
                DockablePanel.this.wm.setResizePos(evt.getX() - DockablePanel.dragStart.x + dimension, DockablePanel.this.panel);
            } else if (position.equals("bottom")) {
                newSize = dimension - evt.getY();
                DockablePanel.this.wm.setResizePos(dimension - evt.getY() + DockablePanel.dragStart.y, DockablePanel.this.panel);
            } else if (position.equals("right")) {
                newSize = dimension - evt.getX();
                DockablePanel.this.wm.setResizePos(dimension - evt.getX() + DockablePanel.dragStart.x, DockablePanel.this.panel);
            }
            if (this.continuousLayout) {
                DockablePanel.this.panel.setDimension(newSize + 10);
                DockablePanel.this.wm.revalidate();
            }
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            if (dragStart == null) {
                DockablePanel.this.wm.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        private int getAppropriateCursor() {
            String position = DockablePanel.this.panel.getPosition();
            if (position.equals("top")) {
                return 8;
            }
            if (position.equals("left")) {
                return 10;
            }
            if (position.equals("bottom")) {
                return 9;
            }
            if (position.equals("right")) {
                return 11;
            }
            throw new InternalError();
        }
    }
}

