/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.Arrays;

public class VariableGridLayout
implements LayoutManager2,
Serializable {
    public static final int FIXED_NUM_ROWS = 1;
    public static final int FIXED_NUM_COLUMNS = 2;
    private int mode;
    private int size;
    private int hgap;
    private int vgap;
    private boolean takeSizesIntoAccount;
    private Insets distanceToBorders;
    private transient int nrows = -1;
    private transient int ncols = -1;
    private transient int[] minimum_row_heights = null;
    private transient int[] minimum_col_widths = null;
    private transient int[] row_heights = null;
    private transient int[] col_widths = null;
    private transient int[] maximum_row_heights = null;
    private transient int[] maximum_col_widths = null;

    public VariableGridLayout(int mode, int size, int hgap, int vgap, boolean takeSizesIntoAccount, Insets distanceToBorders) {
        if (mode != 1 && mode != 2) {
            throw new IllegalArgumentException("illegal mode; value is " + mode);
        }
        if (size <= 0) {
            throw new IllegalArgumentException("size cannot be zero or less; value is " + size);
        }
        if (hgap < 0) {
            throw new IllegalArgumentException("hgap cannot be negative; value is " + hgap);
        }
        if (vgap < 0) {
            throw new IllegalArgumentException("vgap cannot be negative; value is " + vgap);
        }
        this.mode = mode;
        this.size = size;
        this.hgap = hgap;
        this.vgap = vgap;
        this.takeSizesIntoAccount = takeSizesIntoAccount;
        this.distanceToBorders = (Insets)distanceToBorders.clone();
    }

    public VariableGridLayout(int mode, int size, int hgap, int vgap, boolean takeSizesIntoAccount) {
        this(mode, size, hgap, vgap, takeSizesIntoAccount, new Insets(0, 0, 0, 0));
    }

    public VariableGridLayout(int mode, int size, int hgap, int vgap) {
        this(mode, size, hgap, vgap, false, new Insets(0, 0, 0, 0));
    }

    public VariableGridLayout(int mode, int size) {
        this(mode, size, 0, 0, false, new Insets(0, 0, 0, 0));
    }

    public VariableGridLayout() {
        this(1, 1, 0, 0, false, new Insets(0, 0, 0, 0));
    }

    @Override
    public void addLayoutComponent(String name, Component component) {
    }

    @Override
    public void addLayoutComponent(Component component, Object constraints) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.getLayoutSize(parent, LayoutSize.PREFERRED);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.getLayoutSize(parent, LayoutSize.MINIMUM);
    }

    @Override
    public Dimension maximumLayoutSize(Container parent) {
        return this.getLayoutSize(parent, LayoutSize.MAXIMUM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            this.update(parent);
            int ncomponents = parent.getComponentCount();
            if (ncomponents == 0) {
                return;
            }
            int total_height = 0;
            Arrays.fill(this.row_heights, 0);
            Arrays.fill(this.col_widths, 0);
            if (this.takeSizesIntoAccount) {
                Arrays.fill(this.minimum_row_heights, 0);
                Arrays.fill(this.minimum_col_widths, 0);
                Arrays.fill(this.maximum_row_heights, Integer.MAX_VALUE);
                Arrays.fill(this.maximum_col_widths, Integer.MAX_VALUE);
            }
            int i = 0;
            for (int r = 0; r < this.nrows; ++r) {
                for (int c = 0; c < this.ncols && i < ncomponents; ++c, ++i) {
                    Component comp = parent.getComponent(i);
                    Dimension d = comp.getPreferredSize();
                    this.row_heights[r] = Math.max(this.row_heights[r], d.height);
                    this.col_widths[c] = Math.max(this.col_widths[c], d.width);
                    if (!this.takeSizesIntoAccount) continue;
                    d = comp.getMinimumSize();
                    this.minimum_row_heights[r] = Math.max(this.minimum_row_heights[r], d.height);
                    this.minimum_col_widths[c] = Math.max(this.minimum_col_widths[c], d.width);
                    d = comp.getMaximumSize();
                    this.maximum_row_heights[r] = Math.min(this.maximum_row_heights[r], d.height);
                    this.maximum_col_widths[c] = Math.min(this.maximum_col_widths[c], d.width);
                }
                if (this.takeSizesIntoAccount) {
                    if (this.minimum_row_heights[r] >= this.maximum_row_heights[r]) {
                        this.maximum_row_heights[r] = this.minimum_row_heights[r];
                        this.row_heights[r] = this.minimum_row_heights[r];
                    } else if (this.row_heights[r] < this.minimum_row_heights[r]) {
                        this.row_heights[r] = this.minimum_row_heights[r];
                    } else if (this.row_heights[r] > this.maximum_row_heights[r]) {
                        this.row_heights[r] = this.maximum_row_heights[r];
                    }
                }
                total_height += this.row_heights[r];
            }
            int total_width = 0;
            for (int c = 0; c < this.ncols; ++c) {
                if (this.takeSizesIntoAccount) {
                    if (this.minimum_col_widths[c] >= this.maximum_col_widths[c]) {
                        this.maximum_col_widths[c] = this.minimum_col_widths[c];
                        this.col_widths[c] = this.minimum_col_widths[c];
                    } else if (this.col_widths[c] < this.minimum_col_widths[c]) {
                        this.col_widths[c] = this.minimum_col_widths[c];
                    } else if (this.col_widths[c] > this.maximum_col_widths[c]) {
                        this.col_widths[c] = this.maximum_col_widths[c];
                    }
                }
                total_width += this.col_widths[c];
            }
            Dimension parent_size = parent.getSize();
            Insets insets = parent.getInsets();
            int free_height = parent_size.height - insets.top - insets.bottom - (this.nrows - 1) * this.vgap - this.distanceToBorders.top - this.distanceToBorders.bottom;
            int free_width = parent_size.width - insets.left - insets.right - (this.ncols - 1) * this.hgap - this.distanceToBorders.left - this.distanceToBorders.right;
            this.redistributeSpace(total_height, free_height, this.takeSizesIntoAccount, this.nrows, this.row_heights, this.minimum_row_heights, this.maximum_row_heights);
            this.redistributeSpace(total_width, free_width, this.takeSizesIntoAccount, this.ncols, this.col_widths, this.minimum_col_widths, this.maximum_col_widths);
            int y = insets.top + this.distanceToBorders.top;
            int i2 = 0;
            for (int r = 0; r < this.nrows; ++r) {
                int c = 0;
                int x = insets.left + this.distanceToBorders.left;
                while (c < this.ncols) {
                    if (i2 < ncomponents) {
                        Component comp = parent.getComponent(i2);
                        Dimension d = comp.getMaximumSize();
                        int width = this.col_widths[c];
                        int height = this.row_heights[r];
                        int xCorrection = 0;
                        int yCorrection = 0;
                        if (width > d.width) {
                            xCorrection = (int)((float)(width - d.width) * comp.getAlignmentX());
                            width = d.width;
                        }
                        if (height > d.height) {
                            yCorrection = (int)((float)(height - d.height) * comp.getAlignmentY());
                            height = d.height;
                        }
                        comp.setBounds(x + xCorrection, y + yCorrection, width, height);
                    }
                    x += this.col_widths[c] + this.hgap;
                    ++c;
                    ++i2;
                }
                y += this.row_heights[r] + this.vgap;
            }
        }
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    public String toString() {
        return this.getClass().getName() + "[mode=" + (1 == this.mode ? "FIXED_NUM_ROWS" : (2 == this.mode ? "FIXED_NUM_COLUMNS" : "UNKNOWN(" + this.mode + ")")) + ",size=" + this.size + ",hgap=" + this.hgap + ",vgap=" + this.vgap + ",takeSizesIntoAccount=" + this.takeSizesIntoAccount + ",distanceToBorders=" + this.distanceToBorders + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension getLayoutSize(Container parent, LayoutSize which) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            this.update(parent);
            int ncomponents = parent.getComponentCount();
            long h = 0L;
            long w = 0L;
            int i = 0;
            for (int r = 0; r < this.nrows; ++r) {
                int row_height = 0;
                int c = 0;
                while (c < this.ncols) {
                    if (i < ncomponents) {
                        switch (which) {
                            case MINIMUM: {
                                row_height = Math.max(row_height, parent.getComponent((int)i).getMinimumSize().height);
                                break;
                            }
                            case MAXIMUM: {
                                row_height = Math.max(row_height, parent.getComponent((int)i).getMaximumSize().height);
                                break;
                            }
                            case PREFERRED: {
                                row_height = Math.max(row_height, parent.getComponent((int)i).getPreferredSize().height);
                                break;
                            }
                            default: {
                                throw new InternalError("Missing case branch for LayoutSize: " + (Object)((Object)which));
                            }
                        }
                    }
                    ++c;
                    ++i;
                }
                h += (long)row_height;
            }
            for (int c = 0; c < this.ncols; ++c) {
                int col_width = 0;
                block16: for (int r = 0; r < this.nrows; ++r) {
                    int i2 = r * this.ncols + c;
                    if (i2 >= ncomponents) continue;
                    switch (which) {
                        case MINIMUM: {
                            col_width = Math.max(col_width, parent.getComponent((int)i2).getMinimumSize().width);
                            continue block16;
                        }
                        case MAXIMUM: {
                            col_width = Math.max(col_width, parent.getComponent((int)i2).getMaximumSize().width);
                            continue block16;
                        }
                        case PREFERRED: {
                            col_width = Math.max(col_width, parent.getComponent((int)i2).getPreferredSize().width);
                            continue block16;
                        }
                        default: {
                            throw new InternalError("Missing case branch for LayoutSize: " + (Object)((Object)which));
                        }
                    }
                }
                w += (long)col_width;
            }
            Insets insets = parent.getInsets();
            h += (long)(insets.top + insets.bottom + (this.nrows - 1) * this.vgap + this.distanceToBorders.top + this.distanceToBorders.bottom);
            if ((w += (long)(insets.left + insets.right + (this.ncols - 1) * this.hgap + this.distanceToBorders.left + this.distanceToBorders.right)) > Integer.MAX_VALUE) {
                w = Integer.MAX_VALUE;
            }
            if (h > Integer.MAX_VALUE) {
                h = Integer.MAX_VALUE;
            }
            return new Dimension((int)w, (int)h);
        }
    }

    private void update(Container container) {
        int ncomponents = container.getComponentCount();
        int old_nrows = this.nrows;
        int old_ncols = this.ncols;
        if (this.mode == 1) {
            this.nrows = this.size;
            this.ncols = (ncomponents + this.nrows - 1) / this.nrows;
        } else {
            this.ncols = this.size;
            this.nrows = (ncomponents + this.ncols - 1) / this.ncols;
        }
        if (old_nrows != this.nrows) {
            this.row_heights = new int[this.nrows];
            if (this.takeSizesIntoAccount) {
                this.minimum_row_heights = new int[this.nrows];
                this.maximum_row_heights = new int[this.nrows];
            }
        }
        if (old_ncols != this.ncols) {
            this.col_widths = new int[this.ncols];
            if (this.takeSizesIntoAccount) {
                this.minimum_col_widths = new int[this.ncols];
                this.maximum_col_widths = new int[this.ncols];
            }
        }
    }

    private void redistributeSpace(int total_size, int free_size, boolean takeSizesIntoAccount, int nelements, int[] element_sizes, int[] minimum_element_sizes, int[] maximum_element_sizes) {
        block13: {
            if (total_size == free_size) break block13;
            if (takeSizesIntoAccount) {
                boolean grow = total_size < free_size;
                free_size = (free_size - total_size) * (grow ? 1 : -1);
                while (free_size != 0) {
                    int i;
                    int modifyableAmount = 0;
                    int modifySize = 0;
                    for (int i2 = 0; i2 < nelements; ++i2) {
                        if ((!grow || element_sizes[i2] >= maximum_element_sizes[i2]) && (grow || element_sizes[i2] <= minimum_element_sizes[i2])) continue;
                        ++modifyableAmount;
                        modifySize += element_sizes[i2];
                    }
                    boolean checkBounds = true;
                    if (0 == modifyableAmount) {
                        for (i = 0; i < nelements; ++i) {
                            modifySize += element_sizes[i];
                        }
                        checkBounds = false;
                        modifyableAmount = nelements;
                    }
                    if (modifySize == 0) break;
                    if (free_size < modifyableAmount) {
                        for (i = 0; i < nelements; ++i) {
                            if (free_size == 0 || checkBounds && (!checkBounds || !grow || element_sizes[i] >= maximum_element_sizes[i]) && (grow || element_sizes[i] <= minimum_element_sizes[i])) continue;
                            int n = i;
                            element_sizes[n] = element_sizes[n] + (grow ? 1 : -1);
                            if (0 > element_sizes[i]) {
                                element_sizes[i] = 0;
                            }
                            --free_size;
                        }
                        continue;
                    }
                    int modifySizeAddition = 0;
                    for (int i3 = 0; i3 < nelements; ++i3) {
                        int modifyableSize = checkBounds ? (grow ? maximum_element_sizes[i3] - element_sizes[i3] : element_sizes[i3] - minimum_element_sizes[i3]) : Integer.MAX_VALUE - element_sizes[i3];
                        int elementModifySize = (int)((double)free_size / (double)modifySize * (double)element_sizes[i3]);
                        if (elementModifySize <= modifyableSize) {
                            int n = i3;
                            element_sizes[n] = element_sizes[n] + (grow ? elementModifySize : -elementModifySize);
                            modifySizeAddition += grow ? elementModifySize : -elementModifySize;
                            free_size -= elementModifySize;
                        } else {
                            int n = i3;
                            element_sizes[n] = element_sizes[n] + (grow ? modifyableSize : -modifyableSize);
                            modifySizeAddition += grow ? modifyableSize : -modifyableSize;
                            free_size -= modifyableSize;
                        }
                        if (0 <= element_sizes[i3]) continue;
                        element_sizes[i3] = 0;
                    }
                    modifySize += modifySizeAddition;
                }
            } else {
                double d = (double)free_size / (double)total_size;
                for (int i = 0; i < nelements; ++i) {
                    element_sizes[i] = (int)((double)element_sizes[i] * d);
                }
            }
        }
    }

    private static enum LayoutSize {
        MINIMUM,
        MAXIMUM,
        PREFERRED;

    }
}

