/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.BufferOptions;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.ToolTipLabel;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;

public class EncodingWidgetFactory
implements StatusWidgetFactory {
    @Override
    public Widget getWidget(View view) {
        EncodingWidget mode = new EncodingWidget(view);
        return mode;
    }

    private static class EncodingWidget
    implements Widget {
        private final JLabel encoding = new ToolTipLabel();
        private final View view;

        public EncodingWidget(final View view) {
            this.view = view;
            this.encoding.setToolTipText(jEdit.getProperty("view.status.mode-tooltip"));
            this.encoding.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (evt.getClickCount() == 2) {
                        new BufferOptions(view, view.getBuffer());
                    }
                }
            });
        }

        @Override
        public JComponent getComponent() {
            return this.encoding;
        }

        @Override
        public void update() {
            Buffer buffer = this.view.getBuffer();
            if (buffer.isLoaded()) {
                this.encoding.setText(buffer.getStringProperty("encoding"));
            }
        }

        @Override
        public void propertiesChanged() {
        }
    }
}

