/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.ToolTipLabel;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;

public class IndentWidgetFactory
implements StatusWidgetFactory {
    @Override
    public Widget getWidget(View view) {
        IndentWidget indent = new IndentWidget(view);
        return indent;
    }

    private static class IndentWidget
    implements Widget {
        private final JLabel indent = new ToolTipLabel();
        private final View view;

        public IndentWidget(final View view) {
            this.indent.setHorizontalAlignment(0);
            this.view = view;
            this.indent.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    Buffer buffer = view.getBuffer();
                    buffer.toggleAutoIndent(view);
                    IndentWidget.this.update();
                }
            });
        }

        @Override
        public JComponent getComponent() {
            return this.indent;
        }

        @Override
        public void update() {
            Buffer buffer = this.view.getBuffer();
            String indent = buffer.getStringProperty("autoIndent");
            this.indent.setToolTipText(jEdit.getProperty("view.status.indent-tooltip"));
            if ("full".equals(indent)) {
                this.indent.setEnabled(true);
                this.indent.setText("F");
            } else if ("simple".equals(indent)) {
                this.indent.setEnabled(true);
                this.indent.setText("S");
            } else {
                this.indent.setEnabled(false);
                this.indent.setText("n");
            }
        }

        @Override
        public void propertiesChanged() {
        }
    }
}

