/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.bufferio.IoTask;
import org.gjt.sp.jedit.gui.ErrorListDialog;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.io.UrlVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.VFSUpdate;
import org.gjt.sp.util.AwtRunnableQueue;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.Task;
import org.gjt.sp.util.TaskManager;
import org.gjt.sp.util.ThreadUtilities;

public class VFSManager {
    public static final String SERVICE = "org.gjt.sp.jedit.io.VFS";
    private static VFS fileVFS;
    private static VFS urlVFS;
    private static boolean error;
    private static final Object errorLock;
    private static final Vector<ErrorListDialog.ErrorEntry> errors;
    private static final Object vfsUpdateLock;
    private static final List<VFSUpdate> vfsUpdates;
    private static boolean errorDisplayerActive;

    public static void init() {
    }

    public static void start() {
        AwtRunnableQueue.INSTANCE.start();
    }

    public static VFS getFileVFS() {
        return fileVFS;
    }

    public static VFS getUrlVFS() {
        return urlVFS;
    }

    public static VFS getVFSForProtocol(String protocol) {
        if (protocol.equals("file")) {
            return fileVFS;
        }
        VFS vfs = (VFS)ServiceManager.getService(SERVICE, protocol);
        if (vfs != null) {
            return vfs;
        }
        return urlVFS;
    }

    public static VFS getVFSForPath(String path) {
        if (MiscUtilities.isURL(path)) {
            return VFSManager.getVFSForProtocol(MiscUtilities.getProtocolOfURL(path));
        }
        return fileVFS;
    }

    public static String[] getVFSs() {
        LinkedList<String> returnValue = new LinkedList<String>();
        String[] newAPI = ServiceManager.getServiceNames(SERVICE);
        if (newAPI != null) {
            for (int i = 0; i < newAPI.length; ++i) {
                returnValue.add(newAPI[i]);
            }
        }
        return returnValue.toArray(new String[returnValue.size()]);
    }

    public static void waitForRequests() {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException();
        }
        TaskManager.instance.waitForIoTasks();
    }

    public static boolean errorOccurred() {
        return error;
    }

    public static int getRequestCount() {
        return TaskManager.instance.countIoTasks();
    }

    @Deprecated
    public static void runInAWTThread(Runnable run) {
        AwtRunnableQueue.INSTANCE.runAfterIoTasks(run);
    }

    @Deprecated
    public static void runInWorkThread(Task run) {
        if (!(run instanceof IoTask)) {
            throw new IllegalArgumentException();
        }
        ThreadUtilities.runInBackground(run);
    }

    public static void error(IOException e, String path, Component comp) {
        Log.log(9, VFSManager.class, e);
        VFSManager.error(comp, path, "ioerror", new String[]{e.toString()});
    }

    public static void error(Component comp, String path, String messageProp, Object[] args) {
        VFSManager.error(comp, path, messageProp, args, 9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void error(Component comp, String path, String messageProp, Object[] args, int urgency) {
        Frame frame = JOptionPane.getFrameForComponent(comp);
        Object object = errorLock;
        synchronized (object) {
            error = true;
            errors.add(new ErrorListDialog.ErrorEntry(path, messageProp, args, urgency));
            if (errors.size() == 1 && !errorDisplayerActive) {
                ThreadUtilities.runInBackground(new ErrorDisplayer(frame));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendVFSUpdate(VFS vfs, String path, boolean parent) {
        if (parent) {
            VFSManager.sendVFSUpdate(vfs, vfs.getParentOfPath(path), false);
            VFSManager.sendVFSUpdate(vfs, path, false);
        } else {
            if (path.length() != 1 && (path.endsWith("/") || path.endsWith(File.separator))) {
                path = path.substring(0, path.length() - 1);
            }
            Object object = vfsUpdateLock;
            synchronized (object) {
                for (int i = 0; i < vfsUpdates.size(); ++i) {
                    VFSUpdate msg = vfsUpdates.get(i);
                    if (!msg.getPath().equals(path)) continue;
                    return;
                }
                vfsUpdates.add(new VFSUpdate(path));
                if (vfsUpdates.size() == 1) {
                    AwtRunnableQueue.INSTANCE.runAfterIoTasks(new SendVFSUpdatesSafely());
                }
            }
        }
    }

    private VFSManager() {
    }

    static {
        errorLock = new Object();
        vfsUpdateLock = new Object();
        errorDisplayerActive = false;
        errors = new Vector();
        fileVFS = new FileVFS();
        urlVFS = new UrlVFS();
        vfsUpdates = new ArrayList<VFSUpdate>(10);
    }

    private static class ErrorDisplayer
    implements Runnable {
        private Frame frame;

        public ErrorDisplayer(Frame frame) {
            this.frame = frame;
        }

        private void showDialog(final Frame frame, final Vector<ErrorListDialog.ErrorEntry> errors) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        String caption = jEdit.getProperty("ioerror.caption" + (errors.size() == 1 ? "-1" : ""), new Integer[]{errors.size()});
                        new ErrorListDialog(frame.isShowing() ? frame : jEdit.getFirstView(), jEdit.getProperty("ioerror.title"), caption, errors, false);
                    }
                });
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            catch (InvocationTargetException ite) {
                Log.log(9, ErrorDisplayer.class, ite);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = errorLock;
            synchronized (object) {
                if (errorDisplayerActive) {
                    return;
                }
                errorDisplayerActive = true;
            }
            while (true) {
                Vector<ErrorListDialog.ErrorEntry> errorsCopy;
                object = errorLock;
                synchronized (object) {
                    if (errors.size() == 0) {
                        errorDisplayerActive = false;
                        break;
                    }
                }
                int errCount1 = -1;
                int errCount2 = 0;
                while (errCount1 != errCount2) {
                    errCount1 = errors.size();
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                    errCount2 = errors.size();
                }
                Object object2 = errorLock;
                synchronized (object2) {
                    errorsCopy = new Vector<ErrorListDialog.ErrorEntry>(errors);
                    errors.clear();
                    error = false;
                }
                this.showDialog(this.frame, errorsCopy);
            }
        }
    }

    static class SendVFSUpdatesSafely
    implements Runnable {
        SendVFSUpdatesSafely() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = vfsUpdateLock;
            synchronized (object) {
                Collections.sort(vfsUpdates, new StandardUtilities.StringCompare());
                for (int i = 0; i < vfsUpdates.size(); ++i) {
                    EditBus.send((EBMessage)vfsUpdates.get(i));
                }
                vfsUpdates.clear();
            }
        }
    }
}

