/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import java.awt.Component;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.search.BufferListSet;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class AllBufferSet
extends BufferListSet {
    private String glob;
    private View view;

    public AllBufferSet(String glob, View view) {
        this.glob = glob;
        this.view = view;
    }

    public View getView() {
        return this.view;
    }

    public String getFileFilter() {
        return this.glob;
    }

    @Override
    public String getCode() {
        return "new AllBufferSet(\"" + StandardUtilities.charsToEscapes(this.glob) + "\", view)";
    }

    @Override
    protected String[] _getFiles(Component comp) {
        Pattern filter;
        Buffer[] buffers = this.view.getBuffers();
        ArrayList<String> returnValue = new ArrayList<String>(buffers.length);
        try {
            filter = Pattern.compile(StandardUtilities.globToRE(this.glob), 2);
        }
        catch (Exception e) {
            Log.log(9, this, "Error compiling Glob Pattern: " + this.glob, e);
            return null;
        }
        for (int i = 0; i < buffers.length; ++i) {
            Buffer buffer = buffers[i];
            if (!filter.matcher(buffer.getName()).matches()) continue;
            returnValue.add(buffer.getPath());
        }
        return returnValue.toArray(new String[returnValue.size()]);
    }
}

