/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import java.awt.EventQueue;
import java.util.LinkedList;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.TaskManager;
import org.gjt.sp.util.ThreadUtilities;

@ThreadSafe
public enum AwtRunnableQueue {
    INSTANCE;

    @GuardedBy(value="this")
    private boolean awtQueueStarted;
    @GuardedBy(value="this")
    private boolean awtRunnerQueued;
    @GuardedBy(value="this")
    private final LinkedList<Runnable> awtQueue = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        AwtRunnableQueue awtRunnableQueue = this;
        synchronized (awtRunnableQueue) {
            this.awtQueueStarted = true;
        }
        this.queueAWTRunner(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAfterIoTasks(Runnable run) {
        boolean runDirectly = false;
        AwtRunnableQueue awtRunnableQueue = this;
        synchronized (awtRunnableQueue) {
            if (this.awtQueueStarted && TaskManager.instance.countIoTasks() == 0 && this.awtQueue.isEmpty()) {
                runDirectly = true;
            }
        }
        if (runDirectly) {
            ThreadUtilities.runInDispatchThread(run);
            return;
        }
        awtRunnableQueue = this;
        synchronized (awtRunnableQueue) {
            this.awtQueue.offer(run);
        }
        this.queueAWTRunner(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueAWTRunner(boolean wait) {
        if (wait) {
            ThreadUtilities.runInDispatchThreadAndWait(new RunRequestsInAWTThread());
        } else {
            AwtRunnableQueue awtRunnableQueue = this;
            synchronized (awtRunnableQueue) {
                if (this.awtQueue.isEmpty()) {
                    return;
                }
                if (!this.awtQueueStarted || this.awtRunnerQueued) {
                    return;
                }
                this.awtRunnerQueued = true;
            }
            EventQueue.invokeLater(new RunRequestsInAWTThread());
        }
    }

    private class RunRequestsInAWTThread
    implements Runnable {
        private RunRequestsInAWTThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Runnable nextRunnable;
            AwtRunnableQueue awtRunnableQueue = AwtRunnableQueue.this;
            synchronized (awtRunnableQueue) {
                AwtRunnableQueue.this.awtRunnerQueued = false;
                nextRunnable = (Runnable)AwtRunnableQueue.this.awtQueue.peek();
            }
            while (TaskManager.instance.countIoTasks() == 0 && nextRunnable != null) {
                this.doAWTRequest(nextRunnable);
                awtRunnableQueue = AwtRunnableQueue.this;
                synchronized (awtRunnableQueue) {
                    AwtRunnableQueue.this.awtQueue.poll();
                    nextRunnable = (Runnable)AwtRunnableQueue.this.awtQueue.peek();
                }
            }
        }

        private void doAWTRequest(Runnable request) {
            try {
                request.run();
            }
            catch (Throwable t) {
                Log.log(9, this, "Exception in AWT thread:");
                Log.log(9, this, t);
            }
        }
    }
}

