/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import java.util.ArrayList;
import java.util.Collection;

public class StringList
extends ArrayList<String> {
    private static final long serialVersionUID = -6408080298368668262L;

    public StringList() {
    }

    public StringList(Object[] array) {
        this.addAll(array);
    }

    public void addAll(Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            this.add(array[i].toString());
        }
    }

    public static StringList split(String orig, Object delim) {
        if (orig == null || orig.length() == 0) {
            return new StringList();
        }
        return new StringList(orig.split(delim.toString()));
    }

    @Override
    public String toString() {
        return this.join("\n");
    }

    public String[] toArray() {
        int siz = this.size();
        String[] result = new String[siz];
        System.arraycopy(super.toArray(), 0, result, 0, siz);
        return result;
    }

    public static String join(Collection<String> c, String delim) {
        StringList sl = new StringList();
        for (String s : c) {
            sl.add(s);
        }
        return sl.join(delim);
    }

    public static String join(Object[] arr, String delim) {
        return new StringList(arr).join(delim);
    }

    public String join(String delim) {
        int s = this.size();
        if (s < 1) {
            return "";
        }
        if (s == 1) {
            return (String)this.get(0);
        }
        StringBuilder retval = new StringBuilder();
        retval.append((String)this.get(0));
        for (int i = 1; i < s; ++i) {
            retval.append(delim + (String)this.get(i));
        }
        return retval.toString();
    }

    public static void main(String[] args) {
        String teststr = "a,b,c,d,e,f";
        StringList.split(teststr, ",");
        System.out.println("Test Passed");
    }
}

