/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLUtilities {
    public static String charsToEntities(String str, boolean xml11) {
        StringBuilder buf = new StringBuilder(str.length());
        block5: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (('\u0000' <= ch && ch <= '\u001f' || '\u007f' <= ch && ch <= '\u009f') && ch != '\r' && ch != '\n' && ch != '\t') {
                if (xml11 && ch != '\u0000') {
                    buf.append("&#").append((int)ch).append(';');
                    continue;
                }
                buf.append("<?illegal-xml-character ").append((int)ch).append("?>");
                continue;
            }
            switch (ch) {
                case '<': {
                    buf.append("&lt;");
                    continue block5;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block5;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block5;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean parseXML(InputStream in, DefaultHandler handler) throws IOException {
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            InputSource isrc = new InputSource(new BufferedInputStream(in));
            isrc.setSystemId("jedit.jar");
            parser.setContentHandler(handler);
            parser.setDTDHandler(handler);
            parser.setEntityResolver(handler);
            parser.setErrorHandler(handler);
            parser.parse(isrc);
        }
        catch (SAXParseException se) {
            int line = se.getLineNumber();
            Log.log(9, XMLUtilities.class, "while parsing from " + in + ": SAXParseException: line " + line + ": ", se);
            boolean bl = true;
            return bl;
        }
        catch (SAXException e) {
            Log.log(9, XMLUtilities.class, e);
            boolean bl = true;
            return bl;
        }
        finally {
            IOUtilities.closeQuietly((Closeable)in);
        }
        return false;
    }

    public static InputSource findEntity(String systemId, String test, Class<?> where) {
        if (systemId != null && systemId.endsWith(test)) {
            try {
                return new InputSource(new BufferedInputStream(where.getResourceAsStream(test)));
            }
            catch (Exception e) {
                Log.log(9, XMLUtilities.class, "Error while opening " + test + ':');
                Log.log(9, XMLUtilities.class, e);
            }
        }
        return null;
    }

    private XMLUtilities() {
    }
}

