/*
 * Decompiled with CFR 0.152.
 */
package jnpad;

import java.awt.Component;
import java.awt.Insets;
import java.awt.SystemTray;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jnpad.GUIUtilities;
import jnpad.JNPadActionHelper;
import jnpad.JNPadBundle;
import jnpad.JNPadFrame;
import jnpad.JNPadInput;
import jnpad.action.OpenRecentFileAction;
import jnpad.action.SelectAutoCompletionFromNthAction;
import jnpad.action.SelectColorSchemeAction;
import jnpad.action.SelectEncodingAction;
import jnpad.action.SelectFontSizeAction;
import jnpad.action.SelectKeymapAction;
import jnpad.action.SelectLAFAction;
import jnpad.action.SelectLanguageAction;
import jnpad.action.SelectModeAction;
import jnpad.action.SelectTabSizeAction;
import jnpad.config.Config;
import jnpad.config.Mode;
import jnpad.ui.JNPadCheckBoxMenuItem;
import jnpad.ui.JNPadMenuBar;
import jnpad.ui.JNPadMenuItem;
import jnpad.ui.JNPadRadioButtonMenuItem;
import jnpad.ui.MnemonicHelper;
import jnpad.ui.plaf.LAFUtils;
import jnpad.ui.toolbar.PopupButton;
import jnpad.util.Utilities;

final class JNPadMenuHelper {
    JMenuBar menuBar = new JNPadMenuBar();
    JMenu mWindow = new JMenu();
    JMenu mFileRecentFiles = new JMenu();
    JPopupMenu pmRecentFiles = new JPopupMenu();
    PopupButton btRecentFiles = new PopupButton();
    ButtonGroup bgEOL = new ButtonGroup();
    ButtonGroup bgEncoding = new ButtonGroup();
    ButtonGroup bgColorScheme = new ButtonGroup();
    private JNPadFrame jNPad;

    JNPadMenuHelper(JNPadFrame jNPad) {
        this.jNPad = jNPad;
        this.menuBar.setMargin(new Insets(0, 2, 0, 2));
        this.menuBar.setBorder(null);
    }

    JMenuBar getMenuBar() {
        this.menuBar.removeAll();
        JNPadActionHelper actions = this.jNPad.actions;
        this.menuBar.add(this.createFileMenu(actions));
        this.menuBar.add(this.createEditMenu(actions));
        this.menuBar.add(this.createSearchMenu(actions));
        this.menuBar.add(this.createViewMenu(actions));
        this.menuBar.add(this.createFormatMenu(actions));
        this.menuBar.add(this.createConfigureMenu(actions));
        this.menuBar.add(this.createWindowMenu(actions));
        this.menuBar.add(this.createHelpMenu(actions));
        this.menuBar.add(Box.createHorizontalGlue());
        this.menuBar.add(new CloseLabel());
        return this.menuBar;
    }

    private JMenu createFileMenu(JNPadActionHelper actions) {
        JMenu mFile = GUIUtilities.createMenu(JNPadBundle.getString("menu.file", new Object[0]), null);
        mFile.add(new JNPadMenuItem(actions.newFileAction));
        mFile.addSeparator();
        mFile.add(new JNPadMenuItem(actions.openFileAction));
        GUIUtilities.setLocalizedText(this.mFileRecentFiles, JNPadBundle.getString("menu.file.recentFiles", new Object[0]));
        if (Config.isDefaultMode()) {
            this.mFileRecentFiles.setIcon(GUIUtilities.loadIcon("reopen.png"));
        }
        mFile.add(this.mFileRecentFiles);
        mFile.add(new JNPadMenuItem(actions.openAllRecentFilesAction));
        mFile.add(new JNPadMenuItem(actions.emptyRecentFilesListAction));
        mFile.addSeparator();
        mFile.add(new JNPadMenuItem(actions.closeFileAction));
        mFile.add(new JNPadMenuItem(actions.closeFilesAction));
        mFile.add(new JNPadMenuItem(actions.closeAllAction));
        JMenu mFileCloseOther = GUIUtilities.createMenu(JNPadBundle.getString("menu.file.closeOther", new Object[0]), GUIUtilities.EMPTY_ICON);
        mFileCloseOther.add(new JNPadMenuItem(actions.closeOtherAction));
        mFileCloseOther.add(new JNPadMenuItem(actions.closeAllToLeftAction));
        mFileCloseOther.add(new JNPadMenuItem(actions.closeAllToRightAction));
        mFile.add(mFileCloseOther);
        mFile.addSeparator();
        mFile.add(new JNPadMenuItem(actions.saveFileAction));
        mFile.add(new JNPadMenuItem(actions.saveFileAsAction));
        mFile.add(new JNPadMenuItem(actions.saveAllFilesAction));
        mFile.addSeparator();
        mFile.add(new JNPadMenuItem(actions.fileBrowserAction));
        mFile.add(new JNPadMenuItem(actions.filePropertiesAction));
        mFile.addSeparator();
        mFile.add(new JNPadMenuItem(actions.printSetAction));
        mFile.add(new JNPadMenuItem(actions.printAction));
        mFile.addSeparator();
        mFile.add(new JNPadMenuItem(actions.reloadAction));
        mFile.add(new JNPadMenuItem(actions.executeActionAction));
        mFile.addSeparator();
        mFile.add(new JNPadMenuItem(actions.loadSessionAction));
        mFile.add(new JNPadMenuItem(actions.saveSessionAction));
        mFile.addSeparator();
        if (SystemTray.isSupported()) {
            mFile.add(new JNPadMenuItem(actions.reduceAsTrayIconAction));
        }
        mFile.add(new JNPadMenuItem(actions.restartAction));
        mFile.addSeparator();
        mFile.add(new JNPadMenuItem(actions.exitAction));
        if (Config.isDefaultMode()) {
            this.btRecentFiles.setToolTipText(this.mFileRecentFiles.getText());
            this.btRecentFiles.setIcon(this.mFileRecentFiles.getIcon());
        }
        return mFile;
    }

    private JMenu createEditMenu(JNPadActionHelper actions) {
        JMenu mEdit = GUIUtilities.createMenu(JNPadBundle.getString("menu.edit", new Object[0]), null);
        mEdit.add(new JNPadMenuItem(actions.undoAction));
        mEdit.add(new JNPadMenuItem(actions.redoAction));
        mEdit.addSeparator();
        mEdit.add(new JNPadMenuItem(actions.cutAction));
        mEdit.add(new JNPadMenuItem(actions.cutLineAction));
        mEdit.add(new JNPadMenuItem(actions.copyAction));
        mEdit.add(new JNPadMenuItem(actions.copyLineAction));
        mEdit.add(new JNPadMenuItem(actions.pasteAction));
        mEdit.addSeparator();
        mEdit.add(new JNPadMenuItem(actions.selectAllAction));
        JMenu mEditSelectParagraph = GUIUtilities.createMenu(JNPadBundle.getString("menu.edit.selectParagraph", new Object[0]), GUIUtilities.EMPTY_ICON);
        mEditSelectParagraph.add(new JNPadMenuItem(actions.selectParagraphAction));
        mEditSelectParagraph.add(new JNPadMenuItem(actions.selectionBeginParagraphAction));
        mEditSelectParagraph.add(new JNPadMenuItem(actions.selectionEndParagraphAction));
        mEdit.add(mEditSelectParagraph);
        JMenu mEditSelectLine = GUIUtilities.createMenu(JNPadBundle.getString("menu.edit.selectLine", new Object[0]), GUIUtilities.EMPTY_ICON);
        mEditSelectLine.add(new JNPadMenuItem(actions.selectLineAction));
        mEditSelectLine.add(new JNPadMenuItem(actions.selectionBeginLineAction));
        mEditSelectLine.add(new JNPadMenuItem(actions.selectionEndLineAction));
        mEdit.add(mEditSelectLine);
        mEdit.add(new JNPadMenuItem(actions.selectWordAction));
        mEdit.addSeparator();
        mEdit.add(new JNPadMenuItem(actions.deleteAction));
        JMenu mEditDeleteParagraph = GUIUtilities.createMenu(JNPadBundle.getString("menu.edit.deleteParagraph", new Object[0]), GUIUtilities.EMPTY_ICON);
        mEditDeleteParagraph.add(new JNPadMenuItem(actions.deleteParagraphAction));
        mEditDeleteParagraph.add(new JNPadMenuItem(actions.deletionBeginParagraphAction));
        mEditDeleteParagraph.add(new JNPadMenuItem(actions.deletionEndParagraphAction));
        mEdit.add(mEditDeleteParagraph);
        JMenu mEditDeletetLine = GUIUtilities.createMenu(JNPadBundle.getString("menu.edit.deleteLine", new Object[0]), GUIUtilities.EMPTY_ICON);
        mEditDeletetLine.add(new JNPadMenuItem(actions.deleteLineAction));
        mEditDeletetLine.add(new JNPadMenuItem(actions.deletionBeginLineAction));
        mEditDeletetLine.add(new JNPadMenuItem(actions.deletionEndLineAction));
        mEdit.add(mEditDeletetLine);
        mEdit.add(new JNPadMenuItem(actions.deleteWordAction));
        mEdit.addSeparator();
        JMenu mEditionText = GUIUtilities.createMenu(JNPadBundle.getString("menu.edit.text", new Object[0]), GUIUtilities.EMPTY_ICON);
        mEditionText.add(new JNPadMenuItem(actions.tabsToSpacesAction));
        mEditionText.add(new JNPadMenuItem(actions.spacesToTabsAction));
        mEditionText.addSeparator();
        mEditionText.add(new JNPadMenuItem(actions.beginLinesAction));
        mEditionText.add(new JNPadMenuItem(actions.endLinesAction));
        mEditionText.addSeparator();
        mEditionText.add(new JNPadMenuItem(actions.duplicateCurrentLineAction));
        mEditionText.add(new JNPadMenuItem(actions.joinLinesAction));
        mEditionText.add(new JNPadMenuItem(actions.sortLinesAscendingAction));
        mEditionText.add(new JNPadMenuItem(actions.sortLinesDescendingAction));
        mEditionText.add(new JNPadMenuItem(actions.removeEndSpacesAction));
        mEditionText.add(new JNPadMenuItem(actions.removeEmptyLinesAction));
        mEditionText.addSeparator();
        mEditionText.add(new JNPadMenuItem(actions.completeWordAction));
        mEditionText.add(new JNPadMenuItem(actions.completeWordAllAction));
        mEditionText.add(new JNPadMenuItem(actions.wordCountAction));
        mEdit.add(mEditionText);
        JMenu mEditionFile = GUIUtilities.createMenu(JNPadBundle.getString("menu.edit.file", new Object[0]), GUIUtilities.EMPTY_ICON);
        mEditionFile.add(new JNPadMenuItem(actions.insertFileExtensionAction));
        mEditionFile.add(new JNPadMenuItem(actions.insertFileFullNameAction));
        mEditionFile.add(new JNPadMenuItem(actions.insertFileNameAction));
        mEditionFile.addSeparator();
        mEditionFile.add(new JNPadMenuItem(actions.insertFileFullPathAction));
        mEditionFile.add(new JNPadMenuItem(actions.insertFilePathAction));
        mEdit.add(mEditionFile);
        mEdit.add(new JNPadMenuItem(actions.insertDateAction));
        return mEdit;
    }

    private JMenu createSearchMenu(JNPadActionHelper actions) {
        JMenu mSearch = GUIUtilities.createMenu(JNPadBundle.getString("menu.search", new Object[0]), null);
        mSearch.add(new JNPadMenuItem(actions.findAction));
        mSearch.add(new JNPadMenuItem(actions.findNextAction));
        mSearch.add(new JNPadMenuItem(actions.findPreviousAction));
        mSearch.add(new JNPadMenuItem(actions.replaceAction));
        mSearch.add(new JNPadMenuItem(actions.replaceNextAction));
        mSearch.add(new JNPadMenuItem(actions.incrementalSearchAction));
        mSearch.addSeparator();
        mSearch.add(new JNPadMenuItem(actions.highlightAllOccurrencesAction));
        mSearch.add(new JNPadMenuItem(actions.clearAllOccurrencesAction));
        mSearch.add(new JNPadMenuItem(actions.nextOccurrenceAction));
        mSearch.add(new JNPadMenuItem(actions.previousOccurrenceAction));
        mSearch.add(new JNPadMenuItem(actions.goToLineAction));
        mSearch.addSeparator();
        mSearch.add(new JNPadMenuItem(actions.nextBookmarkAction));
        mSearch.add(new JNPadMenuItem(actions.previousBookmarkAction));
        mSearch.add(new JNPadMenuItem(actions.toggleBookmarkAction));
        mSearch.add(new JNPadMenuItem(actions.clearAllBookmarksAction));
        return mSearch;
    }

    private JMenu createViewMenu(JNPadActionHelper actions) {
        JMenu mView = GUIUtilities.createMenu(JNPadBundle.getString("menu.view", new Object[0]), null);
        if (Config.isDefaultMode() || Config.isBasicMode()) {
            JMenu mViewToolbars = GUIUtilities.createMenu(JNPadBundle.getString("menu.view.toolbars", new Object[0]), GUIUtilities.EMPTY_ICON);
            mViewToolbars.add(new JNPadCheckBoxMenuItem(actions.toolBarVisibleAction));
            mViewToolbars.addSeparator();
            mViewToolbars.add(new JNPadCheckBoxMenuItem(actions.toolbarsFileAction));
            mViewToolbars.add(new JNPadCheckBoxMenuItem(actions.toolbarsEditRecantationAction));
            mViewToolbars.add(new JNPadCheckBoxMenuItem(actions.toolbarsEditClipboardAction));
            if (Config.isDefaultMode()) {
                mViewToolbars.add(new JNPadCheckBoxMenuItem(actions.toolbarsEditSelectionAction));
                mViewToolbars.add(new JNPadCheckBoxMenuItem(actions.toolbarsEditDeletionAction));
            }
            mViewToolbars.add(new JNPadCheckBoxMenuItem(actions.toolbarsSearchAction));
            if (Config.isDefaultMode()) {
                mViewToolbars.add(new JNPadCheckBoxMenuItem(actions.toolbarsViewAction));
                mViewToolbars.add(new JNPadCheckBoxMenuItem(actions.toolbarsFormatAction));
            }
            mViewToolbars.add(new JNPadCheckBoxMenuItem(actions.toolbarsWindowAction));
            mViewToolbars.addSeparator();
            mViewToolbars.add(new JNPadMenuItem(actions.toolbarsAllVisibleAction));
            mViewToolbars.add(new JNPadMenuItem(actions.toolbarsNoneVisibleAction));
            mView.add(mViewToolbars);
        }
        mView.add(new JNPadCheckBoxMenuItem(actions.findResultsVisibleAction));
        mView.add(new JNPadCheckBoxMenuItem(actions.statusBarVisibleAction));
        mView.addSeparator();
        mView.add(new JNPadCheckBoxMenuItem(actions.lineWrapAction));
        mView.add(new JNPadCheckBoxMenuItem(actions.lineNumbersAction));
        mView.add(new JNPadCheckBoxMenuItem(actions.activeLineAction));
        mView.add(new JNPadCheckBoxMenuItem(actions.rightMarginLineAction));
        mView.add(new JNPadCheckBoxMenuItem(actions.markStripAction));
        mView.add(new JNPadCheckBoxMenuItem(actions.markOccurrencesAction));
        mView.add(new JNPadCheckBoxMenuItem(actions.markBracketsAction));
        mView.add(new JNPadMenuItem(actions.focusOnMainViewAction));
        ButtonGroup bgScope = new ButtonGroup();
        JMenu mScope = GUIUtilities.createMenu(JNPadBundle.getString("menu.view.scope", new Object[0]), GUIUtilities.EMPTY_ICON);
        mScope.add(new JNPadCheckBoxMenuItem(actions.selectScopeAsViewerAction, bgScope));
        mScope.add(new JNPadCheckBoxMenuItem(actions.selectScopeAsBufferSetAction, bgScope));
        mScope.add(new JNPadCheckBoxMenuItem(actions.selectScopeAsBufferAction, bgScope));
        mScope.add(new JNPadCheckBoxMenuItem(actions.selectScopeAsEditPaneAction, bgScope));
        mView.add(mScope);
        mView.addSeparator();
        mView.add(new JNPadMenuItem(actions.fullScreenAction));
        return mView;
    }

    private JMenu createFormatMenu(JNPadActionHelper actions) {
        JMenu mFormat = GUIUtilities.createMenu(JNPadBundle.getString("menu.format", new Object[0]), null);
        JMenu mEOL = GUIUtilities.createMenu(JNPadBundle.getString("menu.format.eol", new Object[0]), GUIUtilities.EMPTY_ICON);
        mEOL.add(new JNPadCheckBoxMenuItem(actions.selectEOLAsDOSAction, this.bgEOL));
        mEOL.add(new JNPadCheckBoxMenuItem(actions.selectEOLAsUnixAction, this.bgEOL));
        mEOL.add(new JNPadCheckBoxMenuItem(actions.selectEOLAsMacAction, this.bgEOL));
        mFormat.add(mEOL);
        MnemonicHelper mnemonicHelper = new MnemonicHelper();
        JMenu mEncoding = GUIUtilities.createMenu(JNPadBundle.getString("menu.format.encoding", new Object[0]), GUIUtilities.EMPTY_ICON);
        mnemonicHelper.clear();
        TreeSet<String> set = GUIUtilities.getCharsetTreeSet();
        for (String encoding : set) {
            mEncoding.add(new JNPadRadioButtonMenuItem(new SelectEncodingAction(this.jNPad, encoding, mnemonicHelper), this.bgEncoding));
        }
        mFormat.add(mEncoding);
        mFormat.addSeparator();
        mFormat.add(new JNPadMenuItem(actions.rightIndentAction));
        mFormat.add(new JNPadMenuItem(actions.leftIndentAction));
        mFormat.addSeparator();
        mFormat.add(new JNPadMenuItem(actions.toUpperCaseAction));
        mFormat.add(new JNPadMenuItem(actions.toLowerCaseAction));
        mFormat.add(new JNPadMenuItem(actions.invertUpperLowerAction));
        mFormat.add(new JNPadMenuItem(actions.capitalizeAction));
        mFormat.add(new JNPadMenuItem(actions.toTitleAction));
        mFormat.addSeparator();
        mFormat.add(new JNPadCheckBoxMenuItem(actions.setReadOnlyAction));
        JMenu mAlignStrings = GUIUtilities.createMenu(JNPadBundle.getString("menu.format.alignStrings", new Object[0]), GUIUtilities.EMPTY_ICON);
        mAlignStrings.add(new JNPadMenuItem(actions.alignStringsByCommaAction));
        mAlignStrings.add(new JNPadMenuItem(actions.alignStringsByEqualAction));
        mAlignStrings.add(new JNPadMenuItem(actions.alignStringsByClipboardAction));
        mFormat.add(mAlignStrings);
        mFormat.addSeparator();
        mFormat.add(new JNPadMenuItem(actions.increaseFontAction));
        mFormat.add(new JNPadMenuItem(actions.decreaseFontAction));
        return mFormat;
    }

    private JMenu createConfigureMenu(JNPadActionHelper actions) {
        UIManager.LookAndFeelInfo[] lafis;
        JMenu mConfigure = GUIUtilities.createMenu(JNPadBundle.getString("menu.configure", new Object[0]), null);
        JMenu mLanguage = GUIUtilities.createMenu(JNPadBundle.getString("menu.configure.language", new Object[0]), GUIUtilities.EMPTY_ICON);
        ButtonGroup bgLanguage = new ButtonGroup();
        String language = Config.getLocale().getLanguage();
        mLanguage.add(new JNPadRadioButtonMenuItem(new SelectLanguageAction(this.jNPad, JNPadBundle.getString("menu.configure.language.en", new Object[0]), "en", "en".equals(language)), bgLanguage));
        mLanguage.add(new JNPadRadioButtonMenuItem(new SelectLanguageAction(this.jNPad, JNPadBundle.getString("menu.configure.language.es", new Object[0]), "es", "es".equals(language)), bgLanguage));
        mConfigure.add(mLanguage);
        JMenu mMode = GUIUtilities.createMenu(JNPadBundle.getString("menu.configure.mode", new Object[0]), GUIUtilities.EMPTY_ICON);
        ButtonGroup bgMode = new ButtonGroup();
        mMode.add(new JNPadRadioButtonMenuItem(new SelectModeAction(this.jNPad, Mode.DEFAULT), bgMode));
        mMode.add(new JNPadRadioButtonMenuItem(new SelectModeAction(this.jNPad, Mode.BASIC), bgMode));
        mMode.add(new JNPadRadioButtonMenuItem(new SelectModeAction(this.jNPad, Mode.MINIMALIST), bgMode));
        mMode.add(new JNPadRadioButtonMenuItem(new SelectModeAction(this.jNPad, Mode.DISTRACTION_FREE), bgMode));
        mConfigure.add(mMode);
        mConfigure.addSeparator();
        JMenu mAutoCompletion = GUIUtilities.createMenu(JNPadBundle.getString("menu.configure.autoCompletion", new Object[0]), GUIUtilities.EMPTY_ICON);
        mAutoCompletion.add(new JNPadCheckBoxMenuItem(actions.autoCompletionAction));
        mAutoCompletion.addSeparator();
        ButtonGroup bgAutoCompletion = new ButtonGroup();
        int trigger = Config.TEXT_AUTOCOMPLETION_TRIGGER.getValue();
        int nth = 1;
        while (nth < 10) {
            mAutoCompletion.add(new JNPadRadioButtonMenuItem(new SelectAutoCompletionFromNthAction(this.jNPad, nth, nth == trigger), bgAutoCompletion));
            ++nth;
        }
        mConfigure.add(mAutoCompletion);
        mConfigure.addSeparator();
        JMenu mIndentation = GUIUtilities.createMenu(JNPadBundle.getString("menu.configure.indentation", new Object[0]), GUIUtilities.EMPTY_ICON);
        mIndentation.add(new JNPadCheckBoxMenuItem(actions.autoIndentAction));
        mIndentation.add(new JNPadCheckBoxMenuItem(actions.indentUsingSpacesAction));
        mIndentation.addSeparator();
        ButtonGroup bgIndentation = new ButtonGroup();
        int tabSize = Config.TEXT_TAB_SIZE.getValue();
        int size = 1;
        while (size < 9) {
            mIndentation.add(new JNPadRadioButtonMenuItem(new SelectTabSizeAction(this.jNPad, size, size == tabSize), bgIndentation));
            ++size;
        }
        mConfigure.add(mIndentation);
        mConfigure.addSeparator();
        mConfigure.add(new JNPadMenuItem(actions.loadOptionsFileAction));
        mConfigure.add(new JNPadMenuItem(actions.loadDefaultOptionsFileAction));
        mConfigure.add(new JNPadMenuItem(actions.loadShortcutsFileAction));
        mConfigure.add(new JNPadMenuItem(actions.loadLoggingConfigFileAction));
        mConfigure.addSeparator();
        JMenu mFonts = GUIUtilities.createMenu(JNPadBundle.getString("menu.configure.fonts", new Object[0]), GUIUtilities.loadIcon("fonts.png"));
        mFonts.add(new JNPadMenuItem(actions.fontsAction));
        mFonts.addSeparator();
        ButtonGroup bgFontSize = new ButtonGroup();
        mFonts.add(new JNPadRadioButtonMenuItem(new SelectFontSizeAction(this.jNPad, GUIUtilities.FontSize.TINY), bgFontSize));
        mFonts.add(new JNPadRadioButtonMenuItem(new SelectFontSizeAction(this.jNPad, GUIUtilities.FontSize.SMALL), bgFontSize));
        mFonts.add(new JNPadRadioButtonMenuItem(new SelectFontSizeAction(this.jNPad, GUIUtilities.FontSize.NORMAL), bgFontSize));
        mFonts.add(new JNPadRadioButtonMenuItem(new SelectFontSizeAction(this.jNPad, GUIUtilities.FontSize.LARGE), bgFontSize));
        mFonts.add(new JNPadRadioButtonMenuItem(new SelectFontSizeAction(this.jNPad, GUIUtilities.FontSize.HUGE), bgFontSize));
        mFonts.addSeparator();
        mFonts.add(new JNPadMenuItem(actions.resetFontAction));
        mConfigure.add(mFonts);
        JMenu mForeground = GUIUtilities.createMenu(JNPadBundle.getString("menu.configure.foreground", new Object[0]), GUIUtilities.EMPTY_ICON);
        mForeground.add(new JNPadMenuItem(actions.foregroundAction));
        mForeground.addSeparator();
        mForeground.add(new JNPadMenuItem(actions.brightenForegroundAction));
        mForeground.add(new JNPadMenuItem(actions.darkenForegroundAction));
        mForeground.addSeparator();
        mForeground.add(new JNPadMenuItem(actions.resetForegroundAction));
        mConfigure.add(mForeground);
        JMenu mBackground = GUIUtilities.createMenu(JNPadBundle.getString("menu.configure.background", new Object[0]), GUIUtilities.EMPTY_ICON);
        mBackground.add(new JNPadMenuItem(actions.backgroundAction));
        mBackground.addSeparator();
        mBackground.add(new JNPadMenuItem(actions.brightenBackgroundAction));
        mBackground.add(new JNPadMenuItem(actions.darkenBackgroundAction));
        mBackground.addSeparator();
        mBackground.add(new JNPadMenuItem(actions.resetBackgroundAction));
        mConfigure.add(mBackground);
        mConfigure.addSeparator();
        JMenu mColorScheme = GUIUtilities.createMenu(JNPadBundle.getString("menu.configure.colorscheme", new Object[0]), GUIUtilities.loadIcon("colorscheme.png"));
        String colorscheme = Config.JNPAD_COLORSCHEME.getValue();
        File f = new File(Config.COLORSCHEMES_DIR);
        File[] fs = f.listFiles();
        if (fs.length > 0) {
            MnemonicHelper mnemonicHelper = new MnemonicHelper();
            File[] fileArray = fs;
            int n = fs.length;
            int n2 = 0;
            while (n2 < n) {
                File f1 = fileArray[n2];
                String baseName = Utilities.getFileBaseName(f1.getPath());
                mColorScheme.add(new JNPadRadioButtonMenuItem(new SelectColorSchemeAction(this.jNPad, f1, colorscheme.equalsIgnoreCase(baseName), mnemonicHelper), this.bgColorScheme));
                ++n2;
            }
        }
        mConfigure.add(mColorScheme);
        JMenu mKeymap = GUIUtilities.createMenu(JNPadBundle.getString("menu.configure.keymap", new Object[0]), GUIUtilities.EMPTY_ICON);
        ButtonGroup bgKeymap = new ButtonGroup();
        String keymap = Config.JNPAD_KEYMAP.getValue();
        f = new File(Config.KEYMAP_DIR);
        fs = f.listFiles();
        if (fs.length > 0) {
            MnemonicHelper mnemonicHelper = new MnemonicHelper();
            File[] fileArray = fs;
            int n = fs.length;
            int baseName = 0;
            while (baseName < n) {
                File f1 = fileArray[baseName];
                String baseName2 = Utilities.getFileBaseName(f1.getPath());
                mKeymap.add(new JNPadRadioButtonMenuItem(new SelectKeymapAction(this.jNPad, f1, keymap.equalsIgnoreCase(baseName2), mnemonicHelper), bgKeymap));
                ++baseName;
            }
        }
        mConfigure.add(mKeymap);
        JMenu mLookAndFeel = GUIUtilities.createMenu(JNPadBundle.getString("menu.configure.laf", new Object[0]), GUIUtilities.EMPTY_ICON);
        ButtonGroup bgLookAndFeel = new ButtonGroup();
        String laf_key = LAFUtils.getCurrentLAFKey();
        MnemonicHelper mnemonicHelper = new MnemonicHelper();
        mLookAndFeel.add(new JNPadRadioButtonMenuItem(new SelectLAFAction(this.jNPad, "jNPad (Light)", "jNPad_light", "jNPad_light".equals(laf_key), mnemonicHelper), bgLookAndFeel));
        mLookAndFeel.add(new JNPadRadioButtonMenuItem(new SelectLAFAction(this.jNPad, "jNPad (Dark)", "jNPad_dark", "jNPad_dark".equals(laf_key), mnemonicHelper), bgLookAndFeel));
        mLookAndFeel.add(new JNPadRadioButtonMenuItem(new SelectLAFAction(this.jNPad, "Ocean2", "Ocean2", "Ocean2".equals(laf_key), mnemonicHelper), bgLookAndFeel));
        mLookAndFeel.add(new JNPadRadioButtonMenuItem(new SelectLAFAction(this.jNPad, "Steel", "Steel", "Steel".equals(laf_key), mnemonicHelper), bgLookAndFeel));
        mLookAndFeel.addSeparator();
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = lafis = UIManager.getInstalledLookAndFeels();
        int n = lafis.length;
        int n3 = 0;
        while (n3 < n) {
            UIManager.LookAndFeelInfo lafi = lookAndFeelInfoArray[n3];
            boolean b = laf_key.equals(lafi.getClassName());
            mLookAndFeel.add(new JNPadRadioButtonMenuItem(new SelectLAFAction(this.jNPad, lafi, b, mnemonicHelper), bgLookAndFeel));
            ++n3;
        }
        mLookAndFeel.addSeparator();
        mLookAndFeel.add(new JNPadRadioButtonMenuItem(new SelectLAFAction(this.jNPad, JNPadBundle.getString("menu.configure.laf.system", new Object[0]), "System", "System".equals(laf_key), mnemonicHelper), bgLookAndFeel));
        mLookAndFeel.add(new JNPadRadioButtonMenuItem(new SelectLAFAction(this.jNPad, JNPadBundle.getString("menu.configure.laf.java", new Object[0]), "CrossPlatform", "CrossPlatform".equals(laf_key), mnemonicHelper), bgLookAndFeel));
        mConfigure.add(mLookAndFeel);
        return mConfigure;
    }

    private JMenu createWindowMenu(JNPadActionHelper actions) {
        GUIUtilities.setLocalizedText(this.mWindow, JNPadBundle.getString("menu.window", new Object[0]));
        this.mWindow.add(new JNPadMenuItem(actions.windowsAction));
        this.mWindow.addSeparator();
        this.mWindow.add(new JNPadMenuItem(actions.previousBufferAction));
        this.mWindow.add(new JNPadMenuItem(actions.nextBufferAction));
        this.mWindow.addSeparator();
        JMenu mSplitting = GUIUtilities.createMenu(JNPadBundle.getString("menu.window.splitting", new Object[0]), GUIUtilities.EMPTY_ICON);
        mSplitting.add(new JNPadMenuItem(actions.unsplitCurrentAction));
        mSplitting.add(new JNPadMenuItem(actions.unsplitAction));
        mSplitting.add(new JNPadMenuItem(actions.splitHorizontallyAction));
        mSplitting.add(new JNPadMenuItem(actions.splitVerticallyAction));
        mSplitting.add(new JNPadMenuItem(actions.restoreSplitAction));
        mSplitting.addSeparator();
        mSplitting.add(new JNPadMenuItem(actions.previousEditPaneAction));
        mSplitting.add(new JNPadMenuItem(actions.nextEditPaneAction));
        mSplitting.addSeparator();
        mSplitting.add(new JNPadMenuItem(actions.unsplitViewerCurrentAction));
        mSplitting.add(new JNPadMenuItem(actions.unsplitViewerAction));
        mSplitting.add(new JNPadMenuItem(actions.splitViewerHorizontallyAction));
        mSplitting.add(new JNPadMenuItem(actions.splitViewerVerticallyAction));
        mSplitting.add(new JNPadMenuItem(actions.restoreViewerSplitAction));
        mSplitting.addSeparator();
        mSplitting.add(new JNPadMenuItem(actions.previousBufferSetAction));
        mSplitting.add(new JNPadMenuItem(actions.nextBufferSetAction));
        this.mWindow.add(mSplitting);
        this.mWindow.addSeparator();
        return this.mWindow;
    }

    private JMenu createHelpMenu(JNPadActionHelper actions) {
        JMenu mHelp = GUIUtilities.createMenu(JNPadBundle.getString("menu.help", new Object[0]), null);
        mHelp.add(new JNPadMenuItem(actions.cliArgsAction));
        mHelp.add(new JNPadMenuItem(actions.licenceAction));
        mHelp.addSeparator();
        mHelp.add(new JNPadMenuItem(actions.check4UpdatesAction));
        mHelp.addSeparator();
        mHelp.add(new JNPadMenuItem(actions.aboutAction));
        return mHelp;
    }

    JPopupMenu createTabbedPopupMenu() {
        JNPadActionHelper actions = this.jNPad.actions;
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new JNPadMenuItem(actions.saveFileAction));
        popupMenu.add(new JNPadMenuItem(actions.saveFileAsAction));
        popupMenu.add(new JNPadMenuItem(actions.saveAllFilesAction));
        popupMenu.addSeparator();
        popupMenu.add(new JNPadMenuItem(actions.closeFileAction));
        popupMenu.add(new JNPadMenuItem(actions.closeFilesAction));
        popupMenu.add(new JNPadMenuItem(actions.closeAllAction));
        popupMenu.add(new JNPadMenuItem(actions.closeOtherAction));
        popupMenu.add(new JNPadMenuItem(actions.closeAllToLeftAction));
        popupMenu.add(new JNPadMenuItem(actions.closeAllToRightAction));
        popupMenu.addSeparator();
        popupMenu.add(new JNPadMenuItem(actions.printAction));
        popupMenu.addSeparator();
        popupMenu.add(new JNPadMenuItem(actions.reloadAction));
        SwingUtilities.updateComponentTreeUI(popupMenu);
        popupMenu.pack();
        return popupMenu;
    }

    JPopupMenu createEncodingPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        Enumeration<AbstractButton> e = this.bgEncoding.getElements();
        while (e.hasMoreElements()) {
            AbstractButton b = e.nextElement();
            Action a = b.getAction();
            if (a == null) continue;
            popupMenu.add(new JNPadRadioButtonMenuItem(a));
        }
        SwingUtilities.updateComponentTreeUI(popupMenu);
        popupMenu.pack();
        return popupMenu;
    }

    String getMenuFileReOpenPath(String path) {
        return GUIUtilities.getFilePath(this.jNPad.getFontMetrics(this.mFileRecentFiles.getFont()), path, GUIUtilities.getScreenDimension().width / 3);
    }

    void loadRecentFiles() {
        JNPadActionHelper actions = this.jNPad.actions;
        this.mFileRecentFiles.removeAll();
        this.pmRecentFiles.removeAll();
        List<JNPadInput> l = Config.getJNPadInputListProp("files.recent");
        if (l.size() > 0) {
            int i = 0;
            while (i < l.size()) {
                JNPadInput in = l.get(i);
                String path = String.valueOf(i) + "  " + this.getMenuFileReOpenPath(in.getPath());
                OpenRecentFileAction action = new OpenRecentFileAction(this.jNPad, in);
                JMenuItem mi1 = new JMenuItem(action);
                mi1.setText(path);
                this.mFileRecentFiles.add(mi1);
                JMenuItem mi2 = new JMenuItem(action);
                mi2.setText(path);
                this.pmRecentFiles.add(mi2);
                ++i;
            }
        } else {
            this.mFileRecentFiles.setEnabled(false);
            actions.openAllRecentFilesAction.setEnabled(false);
            actions.emptyRecentFilesListAction.setEnabled(false);
            this.btRecentFiles.setEnabled(false);
        }
        this.pmRecentFiles.addSeparator();
        this.pmRecentFiles.add(new JNPadMenuItem(actions.openAllRecentFilesAction));
        this.pmRecentFiles.add(new JNPadMenuItem(actions.emptyRecentFilesListAction));
        this.btRecentFiles.setPopupMenu(this.pmRecentFiles);
        GUIUtilities.setMnemonic(this.mFileRecentFiles, new MnemonicHelper(), false);
    }

    void openAllRecentFiles() {
        Component[] components;
        Component[] componentArray = components = this.mFileRecentFiles.getMenuComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            JMenuItem mi = (JMenuItem)component;
            Action action = mi.getAction();
            if (action != null && action instanceof OpenRecentFileAction) {
                action.actionPerformed(null);
            } else {
                this.jNPad.openFile(mi.getToolTipText());
            }
            ++n2;
        }
    }

    void emptyRecentFilesList() {
        JNPadActionHelper actions = this.jNPad.actions;
        this.mFileRecentFiles.removeAll();
        this.pmRecentFiles.removeAll();
        this.mFileRecentFiles.setEnabled(false);
        actions.openAllRecentFilesAction.setEnabled(false);
        actions.emptyRecentFilesListAction.setEnabled(false);
        this.btRecentFiles.setEnabled(false);
        Config.remove("files.recent");
    }

    void updateRecentFiles(String path, int cursorPosition, boolean isReadOnly, String splitConfig, boolean isLineWrapped) {
        File file = new File(path);
        if (!file.isFile()) {
            return;
        }
        JNPadActionHelper actions = this.jNPad.actions;
        boolean b = false;
        List<JNPadInput> l = Config.getJNPadInputListProp("files.recent");
        int i = 0;
        while (!b && i < l.size()) {
            JNPadInput in = l.get(i);
            if (in.getPath().equals(path)) {
                l.remove(i);
                b = true;
            }
            ++i;
        }
        JNPadInput in = new JNPadInput(path, cursorPosition, isReadOnly, false, splitConfig, isLineWrapped);
        l.add(0, in);
        int max_elements = Config.FILES_RECENT_MAX.getValue();
        if (l.size() > max_elements) {
            Utilities.restrictListSize(l, max_elements);
        }
        Config.setJNPadInputListProp("files.recent", l);
        Component[] components = this.mFileRecentFiles.getMenuComponents();
        String text = this.getMenuFileReOpenPath(path);
        OpenRecentFileAction action = new OpenRecentFileAction(this.jNPad, in);
        JMenuItem mi1 = new JMenuItem(action);
        mi1.setText(text);
        JMenuItem mi2 = new JMenuItem(action);
        mi2.setText(text);
        boolean add = true;
        int i2 = 0;
        while (i2 < components.length) {
            if (((JMenuItem)components[i2]).getToolTipText().equals(path)) {
                this.mFileRecentFiles.remove(i2);
                this.mFileRecentFiles.insert(mi1, 0);
                this.pmRecentFiles.remove(i2);
                this.pmRecentFiles.insert(mi2, 0);
                add = false;
                break;
            }
            ++i2;
        }
        if (add) {
            this.mFileRecentFiles.add((Component)mi1, 0);
            this.pmRecentFiles.add((Component)mi2, 0);
            if (components.length > max_elements) {
                this.mFileRecentFiles.remove(components.length - 1);
                this.pmRecentFiles.remove(components.length - 1);
            }
        }
        this.renameMenuRecentFiles();
        b = this.mFileRecentFiles.getMenuComponentCount() > 0;
        this.mFileRecentFiles.setEnabled(b);
        actions.openAllRecentFilesAction.setEnabled(b);
        actions.emptyRecentFilesListAction.setEnabled(b);
        this.btRecentFiles.setEnabled(b);
    }

    private void renameMenuRecentFiles() {
        Component[] components = this.mFileRecentFiles.getMenuComponents();
        int i = 0;
        while (i < components.length) {
            String s = ((JMenuItem)components[i]).getToolTipText();
            String t = String.valueOf(i) + "  " + this.getMenuFileReOpenPath(s);
            ((JMenuItem)components[i]).setText(t);
            ((JMenuItem)this.pmRecentFiles.getComponent(i)).setText(t);
            ++i;
        }
        GUIUtilities.setMnemonic(this.mFileRecentFiles, new MnemonicHelper(), false);
    }

    private class CloseLabel
    extends JLabel {
        private static final long serialVersionUID = 1624209664888436368L;

        CloseLabel() {
            super(" X ");
            this.setOpaque(false);
            this.setBorder(GUIUtilities.createEmptyBorder(5, 1));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    CloseLabel.this.setOpaque(true);
                    CloseLabel.this.setBackground(LAFUtils.getMenuSelectionBackground());
                    CloseLabel.this.setForeground(LAFUtils.getMenuSelectionForeground());
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    CloseLabel.this.setOpaque(false);
                    CloseLabel.this.setBackground(LAFUtils.getLabelBackground());
                    CloseLabel.this.setForeground(LAFUtils.getLabelForeground());
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    JNPadMenuHelper.this.jNPad.closeFile(null, true);
                }
            });
        }
    }
}

