/*
 * Decompiled with CFR 0.152.
 */
package jnpad;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import jnpad.GUIUtilities;
import jnpad.JNPadBundle;
import jnpad.JNPadFrame;
import jnpad.action.ActionManager;
import jnpad.config.Config;
import jnpad.text.Buffer;
import jnpad.ui.EdgeBorder;
import jnpad.ui.JNPadLabel;
import jnpad.ui.JNPadMenuItem;
import jnpad.ui.status.HeapMonitor;
import jnpad.ui.status.IStatusBar;
import jnpad.ui.status.ITextStatusBar;
import jnpad.ui.status.StatusDisplayable;
import jnpad.util.LinePosition;
import jnpad.util.LineSeparator;

public class JNPadStatusBar
extends JPanel
implements IStatusBar {
    JPanel pnText = new JPanel();
    JPanel pnStatus = new JPanel();
    JNPadMenuItem miHeapMonitor = new JNPadMenuItem(GUIUtilities.loadIcon("java-close.png"));
    private static final String POSITION = "Pos: ";
    private static final String SELECTION = "Sel: ";
    private static final String OCCURRENCES = "Oc: ";
    private static final String MAX_STRING_LINE = JNPadStatusBar.formatLine(9999, 999, 999, 9999, 999);
    private static final String MAX_STRING_POSITION = JNPadStatusBar.formatPosition(999999, 999999);
    private static final String MAX_STRING_CHARACTER = "M  9999  \\u00FF";
    private static final String MAX_STRING_SELECTION = JNPadStatusBar.formatSelection(999999);
    private static final String MAX_STRING_OCCURRENCES = JNPadStatusBar.formatOccurrences(9999);
    private static final String MAX_STRING_EOL = "UNIX";
    private static final String MAX_STRING_ENCODING = "windows-1252";
    private static final String MAX_STRING_TEXT_MODE = JNPadStatusBar.formatTextMode(true);
    JLabel lbLine = new JNPadLabel();
    JLabel lbPosition = new JNPadLabel();
    JLabel lbCharacter = new JNPadLabel();
    JLabel lbSelection = new JNPadLabel();
    JLabel lbOccurrences = new JNPadLabel();
    JLabel lbEOL = new JNPadLabel();
    JLabel lbEncoding = new JNPadLabel();
    JLabel lbTextMode = new JNPadLabel();
    JLabel lbReadOnly = new JNPadLabel();
    JLabel lbCapsLock = new JNPadLabel();
    JLabel lbNumLock = new JNPadLabel();
    JLabel lbStatusBar = new JNPadLabel();
    private boolean isHeapMonitorVisible = Config.HEAP_MONITOR_VISIBLE.getValue();
    private HeapMonitor heapMonitor;
    private Timer timer;
    private JNPadFrame jNPad;
    private static final Logger LOGGER = Logger.getLogger(JNPadStatusBar.class.getName());
    private static final long serialVersionUID = -4781128306022933777L;

    public JNPadStatusBar(JNPadFrame jNPad) {
        super(new BorderLayout());
        try {
            this.jNPad = jNPad;
            this.jbInit();
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    private void jbInit() throws Exception {
        this.add((Component)this.pnText, "North");
        this.add((Component)this.pnStatus, "Center");
        GUIUtilities.updateSize(this.lbLine, MAX_STRING_LINE);
        GUIUtilities.updateSize(this.lbPosition, MAX_STRING_POSITION);
        GUIUtilities.updateSize(this.lbCharacter, MAX_STRING_CHARACTER);
        GUIUtilities.updateSize(this.lbSelection, MAX_STRING_SELECTION);
        GUIUtilities.updateSize(this.lbOccurrences, MAX_STRING_OCCURRENCES);
        GUIUtilities.updateSize(this.lbEOL, MAX_STRING_EOL);
        GUIUtilities.updateSize(this.lbEncoding, MAX_STRING_ENCODING);
        GUIUtilities.updateSize(this.lbTextMode, MAX_STRING_TEXT_MODE);
        this.lbPosition.setHorizontalAlignment(0);
        this.lbCharacter.setHorizontalAlignment(0);
        this.lbSelection.setHorizontalAlignment(0);
        this.lbOccurrences.setHorizontalAlignment(0);
        this.lbEOL.setHorizontalAlignment(0);
        this.lbEncoding.setHorizontalAlignment(0);
        this.lbTextMode.setHorizontalAlignment(0);
        this.lbReadOnly.setHorizontalAlignment(0);
        this.lbCapsLock.setHorizontalAlignment(0);
        this.lbNumLock.setHorizontalAlignment(0);
        this.lbLine.setText(JNPadStatusBar.formatLine(1, 1, 1, 1, 1));
        this.lbLine.setToolTipText(JNPadBundle.getString("JNPadStatusBar.line.tooltip", new Object[0]));
        this.lbPosition.setText(JNPadStatusBar.formatPosition(1, 1));
        this.lbPosition.setToolTipText(JNPadBundle.getString("JNPadStatusBar.position.tooltip", new Object[0]));
        this.lbCharacter.setText("");
        this.lbCharacter.setToolTipText(JNPadBundle.getString("JNPadStatusBar.character.tooltip", new Object[0]));
        this.lbSelection.setText(JNPadStatusBar.formatSelection(0));
        this.lbSelection.setToolTipText(JNPadBundle.getString("JNPadStatusBar.selection.tooltip", new Object[0]));
        this.lbOccurrences.setText(JNPadStatusBar.formatOccurrences(0));
        this.lbOccurrences.setToolTipText(JNPadBundle.getString("JNPadStatusBar.occurrences.tooltip", new Object[0]));
        this.lbEOL.setText("DOS");
        this.lbEOL.setToolTipText(JNPadBundle.getString("JNPadStatusBar.eol.tooltip", new Object[0]));
        this.lbEncoding.setText(Config.FILE_ENCODING.getValue());
        this.lbEncoding.setToolTipText(JNPadBundle.getString("JNPadStatusBar.encoding.tooltip", new Object[0]));
        this.lbTextMode.setText(JNPadStatusBar.formatTextMode(false));
        this.lbTextMode.setToolTipText(JNPadBundle.getString("JNPadStatusBar.textMode.tooltip", new Object[0]));
        this.lbReadOnly.setText(JNPadBundle.getString("JNPadStatusBar.readOnly.text", new Object[0]));
        this.lbReadOnly.setToolTipText(JNPadBundle.getString("JNPadStatusBar.readOnly.tooltip", new Object[0]));
        this.lbReadOnly.setEnabled(false);
        try {
            this.lbCapsLock.setText(JNPadBundle.getString("JNPadStatusBar.capsLock.text", new Object[0]));
            this.lbCapsLock.setEnabled(Toolkit.getDefaultToolkit().getLockingKeyState(20));
        }
        catch (UnsupportedOperationException e) {
            this.lbCapsLock.setText("-");
            this.lbCapsLock.setEnabled(false);
        }
        this.lbCapsLock.setToolTipText(JNPadBundle.getString("JNPadStatusBar.capsLock.tooltip", new Object[0]));
        try {
            this.lbNumLock.setText(JNPadBundle.getString("JNPadStatusBar.numLock.text", new Object[0]));
            this.lbNumLock.setEnabled(Toolkit.getDefaultToolkit().getLockingKeyState(144));
        }
        catch (UnsupportedOperationException e) {
            this.lbNumLock.setText("-");
            this.lbNumLock.setEnabled(false);
        }
        this.lbNumLock.setToolTipText(JNPadBundle.getString("JNPadStatusBar.numLock.tooltip", new Object[0]));
        this.pnStatus.setLayout(new BorderLayout());
        this.pnStatus.setBorder(new EdgeBorder(1));
        this.pnStatus.add((Component)this.lbStatusBar, "Center");
        if (this.isHeapMonitorVisible) {
            this.heapMonitor = new HeapMonitor(this);
            this.pnStatus.add((Component)this.heapMonitor, "East");
        }
        this.pnText.setLayout(new GridBagLayout());
        int gridx = 0;
        int gridy = 0;
        this.pnText.add((Component)this.lbLine, new GridBagConstraints(gridx++, gridy, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.addSeperator(gridx++, gridy);
        this.pnText.add((Component)this.lbPosition, new GridBagConstraints(gridx++, gridy, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.addSeperator(gridx++, gridy);
        this.pnText.add((Component)this.lbCharacter, new GridBagConstraints(gridx++, gridy, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.addSeperator(gridx++, gridy);
        this.pnText.add((Component)this.lbSelection, new GridBagConstraints(gridx++, gridy, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.addSeperator(gridx++, gridy);
        this.pnText.add((Component)this.lbOccurrences, new GridBagConstraints(gridx++, gridy, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.addSeperator(gridx++, gridy);
        this.pnText.add((Component)this.lbEOL, new GridBagConstraints(gridx++, gridy, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.addSeperator(gridx++, gridy);
        this.pnText.add((Component)this.lbEncoding, new GridBagConstraints(gridx++, gridy, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.addSeperator(gridx++, gridy);
        this.pnText.add((Component)this.lbTextMode, new GridBagConstraints(gridx++, gridy, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.addSeperator(gridx++, gridy);
        this.pnText.add((Component)this.lbReadOnly, new GridBagConstraints(gridx++, gridy, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.addSeperator(gridx++, gridy);
        this.pnText.add((Component)this.lbCapsLock, new GridBagConstraints(gridx++, gridy, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.addSeperator(gridx++, gridy);
        this.pnText.add((Component)this.lbNumLock, new GridBagConstraints(gridx, gridy, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        MouseAdapter mouseHandler = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JNPadStatusBar.this.handleMouseClicked(e);
            }
        };
        MouseAdapter popupHandler = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JNPadStatusBar.this.showPopupMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JNPadStatusBar.this.showPopupMenu(e);
                }
            }
        };
        this.lbStatusBar.addMouseListener(popupHandler);
        this.lbLine.addMouseListener(mouseHandler);
        this.lbEOL.addMouseListener(mouseHandler);
        this.lbEncoding.addMouseListener(popupHandler);
        this.lbReadOnly.addMouseListener(mouseHandler);
        this.miHeapMonitor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JNPadStatusBar.this.showHeapMonitor(!JNPadStatusBar.this.isHeapMonitorVisible);
            }
        });
    }

    private void addSeperator(int x, int y) {
        this.pnText.add((Component)new JSeparator(1), new GridBagConstraints(x, y, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 5, 0, 5), 0, 0));
    }

    private void reset() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.lbStatusBar.setIcon(null);
        this.clearStatus();
    }

    @Override
    public void setLinePosition(LinePosition p) {
        this.lbLine.setText(p.toString());
    }

    @Override
    public void setPosition(int pos, int len) {
        this.lbPosition.setText(JNPadStatusBar.formatPosition(pos, len));
    }

    @Override
    public void setCharacter(char c) {
        this.lbCharacter.setText(JNPadStatusBar.formatCharacter(c));
    }

    @Override
    public void setSelection(int sel) {
        this.lbSelection.setText(JNPadStatusBar.formatSelection(sel));
    }

    @Override
    public void setOccurrences(int occ) {
        this.lbOccurrences.setText(JNPadStatusBar.formatOccurrences(occ));
    }

    @Override
    public void setEOL(LineSeparator ls) {
        this.lbEOL.setText(ls.getName());
    }

    @Override
    public void setEncoding(String encoding) {
        this.lbEncoding.setText(encoding);
    }

    @Override
    public boolean isOverwriteTextMode() {
        return "OVR".equals(this.lbTextMode.getText());
    }

    @Override
    public void setAsOverwriteTextMode(boolean b) {
        this.lbTextMode.setText(JNPadStatusBar.formatTextMode(b));
    }

    @Override
    public boolean isReadOnlyIndicatorEnabled() {
        return this.lbReadOnly.isEnabled();
    }

    @Override
    public void setReadOnlyIndicatorEnabled(boolean b) {
        this.lbReadOnly.setEnabled(b);
    }

    @Override
    public boolean isCapsLockIndicatorEnabled() {
        return this.lbCapsLock.isEnabled();
    }

    @Override
    public void setCapsLockIndicatorEnabled(boolean b) {
        this.lbCapsLock.setEnabled(b);
    }

    @Override
    public boolean isNumLockIndicatorEnabled() {
        return this.lbNumLock.isEnabled();
    }

    @Override
    public void setNumLockIndicatorEnabled(boolean b) {
        this.lbNumLock.setEnabled(b);
    }

    @Override
    public String getMessage(ITextStatusBar.StatusMessage message_type) {
        switch (message_type) {
            case STATUS: {
                return this.lbStatusBar.getText();
            }
            case LINE: {
                return this.lbLine.getText();
            }
            case POSITION: {
                return this.lbPosition.getText();
            }
            case CHARACTER: {
                return this.lbCharacter.getText();
            }
            case SELECTION: {
                return this.lbSelection.getText();
            }
            case OCCURRENCES: {
                return this.lbOccurrences.getText();
            }
            case EOL: {
                return this.lbEOL.getText();
            }
            case ENCODING: {
                return this.lbEncoding.getText();
            }
            case TEXT_MODE: {
                return this.lbTextMode.getText();
            }
            case READ_ONLY: {
                return String.valueOf(this.lbReadOnly.isEnabled());
            }
            case CAPS_LOCK: {
                return String.valueOf(this.lbCapsLock.isEnabled());
            }
            case NUM_LOCK: {
                return String.valueOf(this.lbNumLock.isEnabled());
            }
        }
        return "";
    }

    @Override
    public void setMessage(ITextStatusBar.StatusMessage message_type, String message) {
        switch (message_type) {
            case STATUS: {
                this.lbStatusBar.setText(message);
                break;
            }
            case LINE: {
                this.lbLine.setText(message);
                break;
            }
            case POSITION: {
                this.lbPosition.setText(message);
                break;
            }
            case CHARACTER: {
                this.lbCharacter.setText(message);
                break;
            }
            case SELECTION: {
                this.lbSelection.setText(message);
                break;
            }
            case OCCURRENCES: {
                this.lbOccurrences.setText(message);
                break;
            }
            case EOL: {
                this.lbEOL.setText(message);
                break;
            }
            case ENCODING: {
                this.lbEncoding.setText(message);
                break;
            }
            case TEXT_MODE: {
                this.lbTextMode.setText(message);
                break;
            }
            case READ_ONLY: {
                this.lbReadOnly.setEnabled(Boolean.valueOf(message));
                break;
            }
            case CAPS_LOCK: {
                this.lbCapsLock.setEnabled(Boolean.valueOf(message));
                break;
            }
            case NUM_LOCK: {
                this.lbNumLock.setEnabled(Boolean.valueOf(message));
                break;
            }
        }
    }

    private static String formatLine(int line, int column, int character, int lines, int characters) {
        return LinePosition.toString(line, column, character, lines, characters);
    }

    private static String formatPosition(int pos, int len) {
        return POSITION + pos + " / " + len + " (" + (int)((double)pos / (double)len * 100.0) + "%)";
    }

    private static String formatCharacter(char c) {
        return c + "  " + c + "  " + String.format("\\u%04x", c);
    }

    private static String formatSelection(int sel) {
        return SELECTION.concat(String.valueOf(sel));
    }

    private static String formatOccurrences(int occ) {
        return OCCURRENCES.concat(String.valueOf(occ));
    }

    private static String formatTextMode(boolean b) {
        return b ? "OVR" : "INS";
    }

    @Override
    public String getStatus() {
        return this.lbStatusBar.getText();
    }

    @Override
    public void clearStatus() {
        this.setStatus(" ");
    }

    @Override
    public void setStatus(String text) {
        this.setStatus(StatusDisplayable.StatusType.SIMPLE, text, 0);
    }

    @Override
    public void setStatus(String text, int timeout_sec) {
        this.setStatus(StatusDisplayable.StatusType.SIMPLE, text, timeout_sec);
    }

    @Override
    public void setStatus(StatusDisplayable.StatusType type, String text) {
        this.setStatus(type, text, 0);
    }

    @Override
    public void setStatus(final StatusDisplayable.StatusType type, final String text, final int timeout_sec) {
        if (text == null) {
            return;
        }
        GUIUtilities.runOrInvokeLater(new Runnable(){

            @Override
            public void run() {
                if (JNPadStatusBar.this.timer != null) {
                    JNPadStatusBar.this.timer.cancel();
                    JNPadStatusBar.this.timer = null;
                }
                if (timeout_sec > 0) {
                    JNPadStatusBar.this.timer = new Timer();
                    JNPadStatusBar.this.timer.schedule((TimerTask)new ResetTask(), timeout_sec * 1000);
                }
                JNPadStatusBar.this.lbStatusBar.setText(text.length() == 0 ? " " : text);
                switch (type) {
                    case ERROR: {
                        JNPadStatusBar.this.lbStatusBar.setIcon(GUIUtilities.loadIcon("error.png"));
                        break;
                    }
                    case WARNING: {
                        JNPadStatusBar.this.lbStatusBar.setIcon(GUIUtilities.loadIcon("warning.png"));
                        break;
                    }
                    case INFORMATION: {
                        JNPadStatusBar.this.lbStatusBar.setIcon(GUIUtilities.loadIcon("information.png"));
                        break;
                    }
                    default: {
                        JNPadStatusBar.this.lbStatusBar.setIcon(null);
                    }
                }
            }
        });
    }

    void handleMouseClicked(MouseEvent e) {
        Buffer buffer;
        Object obj = e.getSource();
        if (obj == this.lbLine) {
            ActionManager.INSTANCE.executeAction("go-to-line");
        } else if (obj == this.lbEOL) {
            Buffer buffer2 = this.jNPad.getActiveBuffer();
            if (buffer2 != null) {
                LineSeparator lineSeparator = buffer2.getLineSeparator();
                LineSeparator newLineSeparator = null;
                if (lineSeparator == LineSeparator.DOS) {
                    newLineSeparator = LineSeparator.UNIX;
                } else if (lineSeparator == LineSeparator.UNIX) {
                    newLineSeparator = LineSeparator.MAC;
                } else if (lineSeparator == LineSeparator.MAC) {
                    newLineSeparator = LineSeparator.DOS;
                }
                if (newLineSeparator != null) {
                    buffer2.setLineSeparator(newLineSeparator);
                    this.jNPad.setStatus(JNPadBundle.getString("JNPadStatusBar.eol.status", newLineSeparator.getName()), 10);
                }
            }
        } else if (obj == this.lbReadOnly && (buffer = this.jNPad.getActiveBuffer()) != null) {
            buffer.setReadOnly(!this.lbReadOnly.isEnabled());
        }
    }

    void showPopupMenu(MouseEvent e) {
        Object obj = e.getSource();
        if (obj == this.lbStatusBar) {
            JPopupMenu popupMenu = new JPopupMenu();
            if (this.isHeapMonitorVisible) {
                this.miHeapMonitor.setText(JNPadBundle.getString("HeapMonitor.hide.text", new Object[0]));
                this.miHeapMonitor.setDescription(JNPadBundle.getString("HeapMonitor.hide.description", new Object[0]));
                this.miHeapMonitor.setIcon(GUIUtilities.loadIcon("java-close.png"));
            } else {
                this.miHeapMonitor.setText(JNPadBundle.getString("HeapMonitor.show.text", new Object[0]));
                this.miHeapMonitor.setDescription(JNPadBundle.getString("HeapMonitor.hide.description", new Object[0]));
                this.miHeapMonitor.setIcon(GUIUtilities.loadIcon("java-open.png"));
            }
            popupMenu.add(this.miHeapMonitor);
            SwingUtilities.updateComponentTreeUI(popupMenu);
            popupMenu.pack();
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
        } else if (obj == this.lbEncoding) {
            JPopupMenu popupMenu = this.jNPad.createEncodingPopupMenu();
            popupMenu.show(e.getComponent(), e.getX(), e.getY() - popupMenu.getPreferredSize().height);
        }
    }

    @Override
    public void showHeapMonitor(boolean b) {
        if (this.isHeapMonitorVisible != b) {
            if (b) {
                if (this.heapMonitor == null) {
                    this.heapMonitor = new HeapMonitor(this);
                }
                this.pnStatus.add((Component)this.heapMonitor, "East");
            } else if (this.heapMonitor != null) {
                this.pnStatus.remove(this.heapMonitor);
            }
            this.pnStatus.validate();
            this.pnStatus.repaint();
            this.isHeapMonitorVisible = b;
        }
    }

    private class ResetTask
    extends TimerTask {
        private ResetTask() {
        }

        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JNPadStatusBar.this.reset();
                }
            });
        }
    }
}

