/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import java.awt.event.ItemEvent;
import jnpad.JNPadFrame;
import jnpad.action.JNPadAction;
import jnpad.action.JNPadActions;
import jnpad.config.Accelerators;
import jnpad.config.Config;
import jnpad.config.ViewActionScope;
import jnpad.text.Viewer;

public final class ActiveLineAction
extends JNPadAction {
    private static final long serialVersionUID = -3059287624398258328L;

    public ActiveLineAction(JNPadFrame jNPad) {
        super(jNPad, "active-line", JNPadActions.Group.VIEW, Accelerators.ACTIVE_LINE, "active-line.png");
        this.setSelected(Config.ACTIVE_LINE_VISIBLE.getValue());
        this.setStateAction(true);
    }

    @Override
    public void handleStateChanged(ItemEvent e) {
        ViewActionScope scope = Config.VIEW_ACTION_SCOPE.getValue();
        Viewer viewer = this.jNPad.getViewer();
        switch (scope) {
            case VIEWER: {
                viewer.setActiveLineVisible(1 == e.getStateChange());
                break;
            }
            case BUFFER_SET: {
                viewer.getActiveBufferSet().setActiveLineVisible(1 == e.getStateChange());
                break;
            }
            case EDIT_PANE: {
                viewer.getActiveEditPane().setActiveLineVisible(1 == e.getStateChange());
                break;
            }
            default: {
                viewer.getActiveBuffer().setActiveLineVisible(1 == e.getStateChange());
            }
        }
    }
}

