/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.logging.Level;
import java.util.logging.Logger;
import jnpad.JNPadFrame;
import jnpad.action.AlignStringsAction;
import jnpad.config.Accelerators;
import jnpad.ui.status.StatusDisplayable;

public final class AlignStringsByClipboardAction
extends AlignStringsAction {
    private static final Logger LOGGER = Logger.getLogger(AlignStringsByClipboardAction.class.getName());
    private static final long serialVersionUID = -485124264187870371L;

    public AlignStringsByClipboardAction(JNPadFrame jNPad) {
        super(jNPad, "align-strings-by-clipboard", Accelerators.ALIGN_STRINGS_BY_CLIPBOARD);
    }

    @Override
    public void performAction() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        if (transferable != null) {
            try {
                String delimiter = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                this.alignStrings(delimiter);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                this.jNPad.setStatus(StatusDisplayable.StatusType.ERROR, "Error - ".concat(this.getLabel()));
            }
        }
    }
}

