/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import jnpad.GUIUtilities;
import jnpad.JNPadBundle;
import jnpad.JNPadFrame;
import jnpad.action.ActionBundle;
import jnpad.action.JNPadAction;
import jnpad.action.JNPadActions;
import jnpad.config.Accelerators;
import jnpad.ui.ReporterUtilities;
import jnpad.ui.status.StatusDisplayable;
import jnpad.util.Version;

public final class Check4UpdatesAction
extends JNPadAction {
    private static final Logger LOGGER = Logger.getLogger(Check4UpdatesAction.class.getName());
    private static final long serialVersionUID = 6150350042765974110L;

    public Check4UpdatesAction(JNPadFrame jNPad) {
        super(jNPad, "check-for-updates", JNPadActions.Group.HELP, null, "check4updates.png");
        if (Accelerators.isUsingCompositeShortcuts()) {
            this.setKeyBinding(Accelerators.getShortcutLabel("check-for-updates"));
        }
    }

    @Override
    public void performAction() {
        URLConnection connection = null;
        BufferedReader in = null;
        try {
            URL url = new URL("http://rgs.freeiz.com/jnpad/version.html");
            connection = url.openConnection();
            connection.connect();
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String lastVersion = in.readLine();
            if (lastVersion != null) {
                this.jNPad.setStatus(StatusDisplayable.StatusType.INFORMATION, ActionBundle.getString("check-for-updates.latest", lastVersion), 10);
            }
            if (lastVersion == null) {
                ReporterUtilities.reportError(this.jNPad, ActionBundle.getString("check-for-updates.error", new Object[0]));
                return;
            }
            String version = Version.getVersion().trim();
            if (version.equals(lastVersion)) {
                ReporterUtilities.reportInfo(this.jNPad, ActionBundle.getString("check-for-updates.noUpdates.message", version), ActionBundle.getString("check-for-updates.noUpdates.title", new Object[0]));
            } else {
                Object[] options = new String[]{JNPadBundle.getYesOptionText(), JNPadBundle.getNoOptionText()};
                int option = JOptionPane.showOptionDialog(this.jNPad, ActionBundle.getString("check-for-updates.updates.message", lastVersion), ActionBundle.getString("check-for-updates.updates.title", new Object[0]), -1, 3, null, options, options[0]);
                if (option == 1 || option == -1) {
                    return;
                }
                try {
                    GUIUtilities.openBrowser("http://sourceforge.net/projects/jnpad");
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                    ReporterUtilities.reportError(this.jNPad, ActionBundle.getString("check-for-updates.error", new Object[0]), null, ex);
                }
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }
}

