/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JTextField;
import jnpad.GUIUtilities;
import jnpad.JNPadFrame;
import jnpad.action.ActionManager;
import jnpad.action.OpenRecentFileAction;
import jnpad.action.SelectAutoCompletionFromNthAction;
import jnpad.action.SelectColorSchemeAction;
import jnpad.action.SelectEncodingAction;
import jnpad.action.SelectFontSizeAction;
import jnpad.action.SelectKeymapAction;
import jnpad.action.SelectLAFAction;
import jnpad.action.SelectLanguageAction;
import jnpad.action.SelectModeAction;
import jnpad.action.SelectTabSizeAction;
import jnpad.config.Config;
import jnpad.config.Configurable;
import jnpad.ui.EscapableDialog;
import jnpad.util.Utilities;

class ExecuteAction
extends EscapableDialog
implements Configurable {
    JTextField textField = new JTextField();
    private List<String> history;
    private int index_history;
    private List<String> completions;
    private int index_completions;
    private JNPadFrame jNPad;
    private static final long serialVersionUID = -7122058605587960992L;

    ExecuteAction(JNPadFrame jNPad) {
        super((Frame)jNPad, true);
        this.jNPad = jNPad;
        this.setUndecorated(true);
        this.textField.setColumns(Config.PERFORM_ACTION_COLUMNS.getValue());
        this.textField.setFocusTraversalKeysEnabled(false);
        this.textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                ExecuteAction.this.handleKeyPressed(e);
            }
        });
        this.getContentPane().add((Component)this.textField, "Center");
        this.configure(1);
        this.pack();
        double h = Config.PERFORM_ACTION_LOCATION_HORIZONTAL.getValue();
        double v = Config.PERFORM_ACTION_LOCATION_VERTICAL.getValue();
        if (Math.abs(h - 0.5) < 1.0E-7 && Math.abs(v - 0.5) < 1.0E-7 || h < 0.0 || v < 0.0) {
            this.setLocationRelativeTo(jNPad);
        } else if (h >= 0.0 && h <= 1.0 && v >= 0.0 && v <= 1.0) {
            GUIUtilities.setPositionFrameOnScreen(this, h, v);
        } else {
            this.setLocation((int)h, (int)v);
        }
        float transparency = Config.PERFORM_ACTION_TRANSPARENCY.getValue().floatValue();
        if (transparency >= 0.0f && transparency < 1.0f) {
            GUIUtilities.setWindowTransparency(this, transparency);
        }
    }

    @Override
    public void configure(int cfg) {
        this.textField.setFont(Config.TEXT_FONT.getValue());
        this.textField.setBackground(Config.TEXT_BACKGROUND.getValue());
        this.textField.setForeground(Config.TEXT_FOREGROUND.getValue());
        this.textField.setSelectionColor(Config.TEXT_SELECTION_BACKGROUND.getValue());
        this.textField.setSelectedTextColor(Config.TEXT_SELECTION_FOREGROUND.getValue());
        this.textField.setCaretColor(Config.TEXT_CARET_INS_COLOR.getValue());
    }

    private void setPositionFrameOnScreen(double horizontalPercent, double verticalPercent) {
        GUIUtilities.setPositionFrameOnScreen(this, horizontalPercent, verticalPercent);
        Config.PERFORM_ACTION_LOCATION_HORIZONTAL.setValue(horizontalPercent);
        Config.PERFORM_ACTION_LOCATION_VERTICAL.setValue(verticalPercent);
    }

    @Override
    public void requestFocus() {
        this.textField.requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.textField.requestFocusInWindow();
    }

    void handleKeyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        int modifiers = e.getModifiers();
        if (keyCode == 10) {
            this.textField.paintImmediately(0, 0, this.getWidth(), this.getHeight());
            e.consume();
            this.enter();
        } else if (keyCode == 9 && modifiers == 0) {
            e.consume();
            this.tab();
        } else if (keyCode == 38 || keyCode == 224) {
            this.previousHistory();
        } else if (keyCode == 40 || keyCode == 225) {
            this.nextHistory();
        } else if (keyCode == 82 && modifiers == 2) {
            this.resetHistory();
        } else if (keyCode == 127 && modifiers == 2) {
            e.consume();
            this.textField.setText("");
        } else if (modifiers == 2 && (keyCode == 97 || keyCode == 49)) {
            this.setPositionFrameOnScreen(0.0, 1.0);
        } else if (modifiers == 2 && (keyCode == 98 || keyCode == 50)) {
            e.consume();
            this.setPositionFrameOnScreen(0.5, 1.0);
        } else if (modifiers == 2 && (keyCode == 99 || keyCode == 51)) {
            e.consume();
            this.setPositionFrameOnScreen(1.0, 1.0);
        } else if (modifiers == 2 && (keyCode == 100 || keyCode == 52)) {
            this.setPositionFrameOnScreen(0.0, 0.5);
        } else if (modifiers == 2 && (keyCode == 101 || keyCode == 53)) {
            this.setPositionFrameOnScreen(0.5, 0.5);
        } else if (modifiers == 2 && (keyCode == 102 || keyCode == 54)) {
            this.setPositionFrameOnScreen(1.0, 0.5);
        } else if (modifiers == 2 && (keyCode == 103 || keyCode == 55)) {
            this.setPositionFrameOnScreen(0.0, 0.0);
        } else if (modifiers == 2 && (keyCode == 104 || keyCode == 56)) {
            this.setPositionFrameOnScreen(0.5, 0.0);
        } else if (modifiers == 2 && (keyCode == 105 || keyCode == 57)) {
            this.setPositionFrameOnScreen(1.0, 0.0);
        } else {
            this.resetCompletions();
        }
    }

    private void enter() {
        String input = this.textField.getText();
        if (Utilities.isEmptyString(input)) {
            return;
        }
        if (!this.performAction(input)) {
            this.jNPad.setStatus(input);
        }
        this.addToHistory(input);
        this.setVisible(false);
        this.textField.setText("");
        this.jNPad.getViewer().focusOnActiveBuffer();
    }

    private boolean performAction(String input) {
        if (input.startsWith("select-colorscheme")) {
            return SelectColorSchemeAction.performAction(input);
        }
        if (input.startsWith("select-mode")) {
            return SelectModeAction.performAction(input);
        }
        if (input.startsWith("select-fontsize")) {
            return SelectFontSizeAction.performAction(input);
        }
        if (input.startsWith("select-encoding")) {
            return SelectEncodingAction.performAction(input);
        }
        if (input.startsWith("select-laf")) {
            return SelectLAFAction.performAction(input);
        }
        if (input.startsWith("select-keymap")) {
            return SelectKeymapAction.performAction(input);
        }
        if (input.startsWith("select-language")) {
            return SelectLanguageAction.performAction(input);
        }
        if (input.startsWith("select-tab-size")) {
            return SelectTabSizeAction.performAction(input);
        }
        if (input.startsWith("select-autocompletion-from-nth")) {
            return SelectAutoCompletionFromNthAction.performAction(input);
        }
        if (input.startsWith("open-recent-file")) {
            return OpenRecentFileAction.performAction(input);
        }
        return ActionManager.INSTANCE.executeAction(input);
    }

    private void tab() {
        String prefix = this.textField.getText();
        String s = this.getCompletion(prefix);
        if (s != null && !s.equals(prefix)) {
            this.textField.setText(s);
            this.textField.setCaretPosition(s.length());
        }
    }

    private String getCompletion(String prefix) {
        if (this.completions == null) {
            this.completions = this.getCompletions(prefix);
            this.index_completions = 0;
        }
        if (Utilities.isEmptyList(this.completions)) {
            GUIUtilities.beep();
            return null;
        }
        if (this.index_completions >= this.completions.size()) {
            this.index_completions = 0;
        }
        return this.completions.get(this.index_completions++);
    }

    private List<String> getCompletions(String prefix) {
        int index_space = prefix.indexOf(32);
        if (index_space != -1) {
            String action_name = prefix.substring(0, index_space);
            if ("select-colorscheme".equals(action_name)) {
                return SelectColorSchemeAction.getCompletionsForPrefix(prefix);
            }
            if ("select-mode".equals(action_name)) {
                return SelectModeAction.getCompletionsForPrefix(prefix);
            }
            if ("select-fontsize".equals(action_name)) {
                return SelectFontSizeAction.getCompletionsForPrefix(prefix);
            }
            if ("select-encoding".equals(action_name)) {
                return SelectEncodingAction.getCompletionsForPrefix(prefix);
            }
            if ("select-laf".equals(action_name)) {
                return SelectLAFAction.getCompletionsForPrefix(prefix);
            }
            if ("select-keymap".equals(action_name)) {
                return SelectKeymapAction.getCompletionsForPrefix(prefix);
            }
            if ("select-language".equals(action_name)) {
                return SelectLanguageAction.getCompletionsForPrefix(prefix);
            }
            if ("select-tab-size".equals(action_name)) {
                return SelectTabSizeAction.getCompletionsForPrefix(prefix);
            }
            if ("select-autocompletion-from-nth".equals(action_name)) {
                return SelectAutoCompletionFromNthAction.getCompletionsForPrefix(prefix);
            }
            if ("open-recent-file".equals(action_name)) {
                return OpenRecentFileAction.getCompletionsForPrefix(prefix);
            }
        }
        List<String> list = ActionManager.INSTANCE.getCompletionsForPrefix(prefix);
        boolean sort = false;
        if ("select-colorscheme".startsWith(prefix)) {
            list.add("select-colorscheme");
            sort = true;
        }
        if ("select-mode".startsWith(prefix)) {
            list.add("select-mode");
            sort = true;
        }
        if ("select-fontsize".startsWith(prefix)) {
            list.add("select-fontsize");
            sort = true;
        }
        if ("select-encoding".startsWith(prefix)) {
            list.add("select-encoding");
            sort = true;
        }
        if ("select-laf".startsWith(prefix)) {
            list.add("select-laf");
            sort = true;
        }
        if ("select-keymap".startsWith(prefix)) {
            list.add("select-keymap");
            sort = true;
        }
        if ("select-language".startsWith(prefix)) {
            list.add("select-language");
            sort = true;
        }
        if ("select-tab-size".startsWith(prefix)) {
            list.add("select-tab-size");
            sort = true;
        }
        if ("select-autocompletion-from-nth".startsWith(prefix)) {
            list.add("select-autocompletion-from-nth");
            sort = true;
        }
        if ("open-recent-file".startsWith(prefix)) {
            list.add("open-recent-file");
            sort = true;
        }
        if (sort) {
            Collections.sort(list);
        }
        return list;
    }

    private void resetCompletions() {
        if (this.completions != null) {
            this.completions = null;
        }
    }

    private void addToHistory(String input) {
        if (this.history == null) {
            this.history = new ArrayList<String>();
        }
        this.history.add(input);
        this.index_history = this.history.size();
    }

    private void resetHistory() {
        if (this.history != null) {
            this.history = null;
        }
    }

    private void previousHistory() {
        String s;
        if (this.history == null) {
            GUIUtilities.beep();
            return;
        }
        String text = this.textField.getText();
        while ((s = this.getPrevious()) != null) {
            if (s.equals(text)) continue;
            this.textField.setText(s);
            break;
        }
    }

    private String getPrevious() {
        if (this.history != null && this.index_history > 0 && this.index_history <= this.history.size()) {
            return this.history.get(--this.index_history);
        }
        GUIUtilities.beep();
        return null;
    }

    private void nextHistory() {
        String s;
        if (this.history == null) {
            GUIUtilities.beep();
            return;
        }
        String text = this.textField.getText();
        while ((s = this.getNext()) != null) {
            if (s.equals(text)) continue;
            this.textField.setText(s);
            break;
        }
    }

    private String getNext() {
        if (this.history != null && this.index_history < this.history.size() - 1 && this.index_history >= 0) {
            return this.history.get(++this.index_history);
        }
        GUIUtilities.beep();
        return null;
    }
}

