/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jnpad.GUIUtilities;
import jnpad.JNPadFrame;
import jnpad.JNPadInput;
import jnpad.action.JNPadAction;
import jnpad.action.JNPadActions;
import jnpad.config.Config;

public final class OpenRecentFileAction
extends JNPadAction {
    private JNPadInput in;
    static final String NAME = "open-recent-file";
    private static Map<String, JNPadAction> map = new HashMap<String, JNPadAction>();
    private static final long serialVersionUID = 4720060976039922757L;

    public OpenRecentFileAction(JNPadFrame jNPad, JNPadInput in) {
        super(jNPad, NAME, JNPadActions.Group.FILE);
        this.in = in;
        String ttip = in.getPath();
        String name = "open-recent-file " + ttip;
        this.setToolTipText(ttip);
        this.setName(name);
        if (Config.isDefaultMode()) {
            if (in.isReadOnly()) {
                this.setIcon(GUIUtilities.loadIcon("file-readonly.png"));
            } else {
                this.setIcon(GUIUtilities.loadIcon("file.png"));
            }
        }
        map.put(name, this);
    }

    @Override
    public void performAction() {
        this.jNPad.openFile(this.in);
    }

    static List<String> getCompletionsForPrefix(String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : map.keySet()) {
            JNPadAction action = map.get(key);
            if (!key.startsWith(prefix) || !action.isEnabled()) continue;
            list.add(key);
        }
        Collections.sort(list);
        return list;
    }

    static boolean performAction(String name) {
        JNPadAction action = map.get(name);
        if (action != null && action.isEnabled()) {
            action.performAction();
            return true;
        }
        return false;
    }
}

