/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import jnpad.JNPadBundle;
import jnpad.JNPadFrame;
import jnpad.action.ActionBundle;
import jnpad.action.JNPadAction;
import jnpad.action.JNPadActions;
import jnpad.config.Config;
import jnpad.ui.MnemonicHelper;

public final class SelectLAFAction
extends JNPadAction {
    private UIManager.LookAndFeelInfo info;
    private String lafKey;
    static final String NAME = "select-laf";
    private static Map<String, JNPadAction> map = new HashMap<String, JNPadAction>();
    private static final long serialVersionUID = -7427981107412256683L;

    public SelectLAFAction(JNPadFrame jNPad, String label, String lafKey, boolean selected, MnemonicHelper mnemonicHelper) {
        super(jNPad, NAME, JNPadActions.Group.CONFIGURE);
        char mnemonic;
        this.lafKey = lafKey;
        this.setLabel(label);
        String name = "select-laf " + label;
        this.setName(name);
        if (mnemonicHelper != null && (mnemonic = mnemonicHelper.getMnemonic(label)) != '\u0000') {
            this.setMnemonic(mnemonic);
        }
        this.setDescription(ActionBundle.getString(NAME.concat(".description"), label));
        this.setSelected(selected);
        this.setStateAction(true);
        map.put(name, this);
    }

    public SelectLAFAction(JNPadFrame jNPad, UIManager.LookAndFeelInfo info, boolean selected, MnemonicHelper mnemonicHelper) {
        super(jNPad, NAME, JNPadActions.Group.CONFIGURE);
        char mnemonic;
        this.info = info;
        String label = info.getName();
        String name = "select-laf " + label;
        this.setLabel(label);
        this.setName(name);
        if (mnemonicHelper != null && (mnemonic = mnemonicHelper.getMnemonic(label)) != '\u0000') {
            this.setMnemonic(mnemonic);
        }
        this.setDescription(ActionBundle.getString(NAME.concat(".description"), label));
        this.setSelected(selected);
        this.setStateAction(true);
        map.put(name, this);
    }

    @Override
    public void handleStateChanged(ItemEvent e) {
        if (1 == e.getStateChange()) {
            Config.JNPAD_LAF.setValue(this.info != null ? this.info.getClassName() : this.lafKey);
            Config.setAdjustPostLAFChangedEnabled(true);
            String msg = ActionBundle.getString("select-laf.message", this.getLabel());
            this.jNPad.setStatus(msg, 10);
            Object[] options = new String[]{JNPadBundle.getYesOptionText(), JNPadBundle.getNoOptionText()};
            int option = JOptionPane.showOptionDialog(this.jNPad, JNPadBundle.getString("JNPad.restart", msg), JNPadBundle.getString("select-laf.title", new Object[0]), -1, 1, null, options, options[0]);
            if (option == 1 || option == -1) {
                return;
            }
            this.jNPad.restart();
        }
    }

    static List<String> getCompletionsForPrefix(String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : map.keySet()) {
            JNPadAction action = map.get(key);
            if (!key.startsWith(prefix) || !action.isEnabled()) continue;
            list.add(key);
        }
        Collections.sort(list);
        return list;
    }

    static boolean performAction(String name) {
        JNPadAction action = map.get(name);
        if (action != null && action.isEnabled()) {
            action.setSelected(!action.isSelected());
            return true;
        }
        return false;
    }
}

