/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import javax.swing.JOptionPane;
import jnpad.JNPadFrame;
import jnpad.action.ActionBundle;
import jnpad.action.JNPadAction;
import jnpad.action.JNPadActions;
import jnpad.config.Accelerators;
import jnpad.text.EditPane;
import jnpad.text.JNPadTextArea;

public final class WordCountAction
extends JNPadAction {
    private static final long serialVersionUID = -9168815841017327401L;

    public WordCountAction(JNPadFrame jNPad) {
        super(jNPad, "word-count", JNPadActions.Group.EDIT, Accelerators.WORD_COUNT, null);
    }

    @Override
    public void performAction() {
        EditPane editPane = this.jNPad.getActiveEditPane();
        if (editPane != null) {
            String selectedText;
            JNPadTextArea textArea = editPane.getTextArea();
            String text = textArea.getText();
            int start = textArea.getSelectionStart();
            int end = textArea.getCaretPosition();
            if (end < start) {
                start ^= end;
                end = start ^ end;
                start ^= end;
            }
            if (start != end) {
                if (end > text.length()) {
                    --end;
                }
                if (end < 0) {
                    end = 0;
                }
                selectedText = text.substring(start, end);
            } else {
                selectedText = text;
            }
            int lines = 1;
            int words = 0;
            boolean word = false;
            int characters = selectedText.length();
            int i = 0;
            while (i < selectedText.length()) {
                switch (selectedText.charAt(i)) {
                    case '\n': {
                        ++lines;
                    }
                    case '\t': 
                    case ' ': {
                        if (!word) break;
                        ++words;
                        word = false;
                        break;
                    }
                    default: {
                        word = true;
                        if (i != selectedText.length() - 1) break;
                        ++words;
                    }
                }
                ++i;
            }
            Object[] args = new Object[]{ActionBundle.getString("word-count".concat(".words"), words), ActionBundle.getString("word-count".concat(".characters"), characters), ActionBundle.getString("word-count".concat(".lines"), lines)};
            JOptionPane.showMessageDialog(this.jNPad, args, ActionBundle.getString("word-count".concat(".message"), new Object[0]), 1);
        }
    }
}

