/*
 * Decompiled with CFR 0.152.
 */
package jnpad.filebrowser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import jnpad.GUIUtilities;
import jnpad.JNPadFrame;
import jnpad.config.Config;
import jnpad.config.Configurable;
import jnpad.filebrowser.DirectoryFilter;
import jnpad.filebrowser.FileBrowserBundle;
import jnpad.filebrowser.FileBrowserFilter;
import jnpad.filebrowser.FileBrowserObject;
import jnpad.filebrowser.FileList;
import jnpad.ui.ColorUtilities;
import jnpad.ui.EscapableDialog;
import jnpad.ui.ReporterUtilities;
import jnpad.ui.SideBorder;
import jnpad.ui.plaf.LAFUtils;

public class FileBrowser
extends EscapableDialog
implements Configurable {
    JScrollPane scrollPane = new JScrollPane();
    FileList fileList;
    DirectoryFilter directoryFilter = new DirectoryFilter();
    FileBrowserFilter fileFilter = new FileBrowserFilter();
    JLabel info = new JLabel();
    private JNPadFrame jNPad;
    private static final String ENABLED = FileBrowserBundle.getString("FileBrowser.enabled", new Object[0]);
    private static final String DISABLED = FileBrowserBundle.getString("FileBrowser.disabled", new Object[0]);
    private static final long serialVersionUID = -9096054333515066973L;

    public FileBrowser(JNPadFrame jNPad) {
        super((Frame)jNPad, true);
        int max;
        this.jNPad = jNPad;
        this.setUndecorated(true);
        this.fileList = new FileList(this);
        this.goToHomeDir();
        this.scrollPane.setVerticalScrollBarPolicy(21);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.getViewport().add((Component)this.fileList, null);
        this.info.setText(FileBrowserBundle.getString("FileBrowser.info", new Object[0]));
        this.info.setHorizontalAlignment(0);
        this.info.setOpaque(true);
        Font f = Config.BROWSER_NORMAL_FONT.getValue();
        this.info.setFont(new Font(f.getName(), 0, f.getSize() - 1));
        if (LAFUtils.isNimbusLAF()) {
            this.info.setBackground(new Color(242, 242, 189));
            this.info.setForeground(ColorUtilities.createPureColor(LAFUtils.getToolTipForeground()));
        } else {
            this.info.setBackground(LAFUtils.getToolTipBackground());
            this.info.setForeground(LAFUtils.getToolTipForeground());
        }
        Color c = this.info.getBackground().darker();
        this.info.setBorder(new SideBorder(null, c, c, c, 1));
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.getContentPane().add((Component)this.info, "South");
        int width = this.info.getPreferredSize().width + 10;
        if (width < 600) {
            width = 600;
        }
        if (width > (max = GUIUtilities.getScreenDimension().width - 40)) {
            width = max;
        }
        this.setSize(new Dimension(width, 400));
        double h = Config.BROWSER_LOCATION_HORIZONTAL.getValue();
        double v = Config.BROWSER_LOCATION_VERTICAL.getValue();
        if (Math.abs(h - 0.5) < 1.0E-7 && Math.abs(v - 0.5) < 1.0E-7 || h < 0.0 || v < 0.0) {
            this.setLocationRelativeTo(jNPad);
        } else if (h >= 0.0 && h <= 1.0 && v >= 0.0 && v <= 1.0) {
            GUIUtilities.setPositionFrameOnScreen(this, h, v);
        } else {
            this.setLocation((int)h, (int)v);
        }
        this.info.setVisible(Config.BROWSER_INFO_VISIBLE.getValue());
        float transparency = Config.BROWSER_TRANSPARENCY.getValue().floatValue();
        if (transparency >= 0.0f && transparency < 1.0f) {
            GUIUtilities.setWindowTransparency(this, transparency);
        }
    }

    @Override
    public void configure(int cfg) {
        this.fileList.configure(cfg);
        this.refresh();
    }

    void setPositionFrameOnScreen(double horizontalPercent, double verticalPercent) {
        GUIUtilities.setPositionFrameOnScreen(this, horizontalPercent, verticalPercent);
        Config.BROWSER_LOCATION_HORIZONTAL.setValue(horizontalPercent);
        Config.BROWSER_LOCATION_VERTICAL.setValue(verticalPercent);
    }

    void toggleInfoVisible() {
        boolean b = Config.BROWSER_INFO_VISIBLE.getValue();
        Config.BROWSER_INFO_VISIBLE.setValue(!b);
        this.info.setVisible(!b);
        this.setStatus(FileBrowserBundle.getString("FileBrowser.status.info", !b ? ENABLED : DISABLED));
    }

    void toggleColor() {
        boolean b = Config.BROWSER_COLORS_ENABLED.getValue();
        Config.BROWSER_COLORS_ENABLED.setValue(!b);
        FileBrowserObject.updateDirColors();
        this.refresh();
        this.setStatus(FileBrowserBundle.getString("FileBrowser.status.color", !b ? ENABLED : DISABLED));
    }

    void toggleHumanReadable() {
        boolean b = Config.BROWSER_HUMAN_READABLE.getValue();
        Config.BROWSER_HUMAN_READABLE.setValue(!b);
        this.refresh();
        this.setStatus(FileBrowserBundle.getString("FileBrowser.status.humanReadable", !b ? ENABLED : DISABLED));
    }

    void toggleClassify() {
        boolean b = Config.BROWSER_CLASSIFY.getValue();
        Config.BROWSER_CLASSIFY.setValue(!b);
        FileBrowserObject.updateDirColors();
        this.refresh();
        this.setStatus(FileBrowserBundle.getString("FileBrowser.status.classify", !b ? ENABLED : DISABLED));
    }

    @Override
    public void requestFocus() {
        this.fileList.requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.fileList.requestFocusInWindow();
    }

    public File getFile() {
        return this.fileList.getFile();
    }

    public void refresh(String s) {
        this.fileList.refresh(s);
    }

    public void refresh() {
        this.fileList.refresh();
    }

    public boolean listFile(File file) {
        return this.fileList.listFile(file);
    }

    void goToHomeDir() {
        File file = new File(Config.CHOOSER_FILE_DIRECTORY.getValue());
        if (!file.exists()) {
            file = new File(System.getProperties().getProperty("user.dir", "/"));
        }
        if (!file.exists()) {
            file = new File(FileList.FILE_SYSTEM_ROOTS[FileList.FILE_SYSTEM_ROOTS.length - 1].getPath());
        }
        this.listFile(file);
    }

    public void setHomeDir(String s) {
        this.setHomeDir(new File(s));
    }

    public void setHomeDir(File file) {
        if (file.exists() && file.isDirectory()) {
            Config.CHOOSER_FILE_DIRECTORY.setValue(file.getPath());
            this.setStatus(FileBrowserBundle.getString("FileBrowser.setHomeDir", file.getPath()));
        }
    }

    public void openFile() {
        File file = new File(this.fileList.getPath());
        if (file.exists() && file.isFile()) {
            this.jNPad.openFile(file.getAbsolutePath());
            this.fileList.requestFocus();
        } else if (!file.exists()) {
            this.setStatus(FileBrowserBundle.getString("FileBrowser.openFile.error.status", file.getAbsolutePath()));
            ReporterUtilities.reportError(this.jNPad, FileBrowserBundle.getString("FileBrowser.openFile.error.message", file.getAbsolutePath()), FileBrowserBundle.getString("FileBrowser.openFile.error.title", new Object[0]));
        }
    }

    void setStatus(String status) {
        this.jNPad.setStatus(status);
    }
}

