/*
 * Decompiled with CFR 0.152.
 */
package jnpad.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import jnpad.GUIUtilities;
import jnpad.JNPadFrame;
import jnpad.config.Config;
import jnpad.search.SearchBundle;
import jnpad.search.SearchContext;
import jnpad.search.SearchDialog;
import jnpad.search.Text;
import jnpad.text.Buffer;
import jnpad.text.EditPane;
import jnpad.text.JNPadTextArea;
import jnpad.ui.JNPadComboBox;
import jnpad.ui.JNPadLabel;
import jnpad.util.Utilities;

public class ReplaceDialog
extends SearchDialog {
    JButton btReplace = new JButton();
    JButton btReplaceAll = new JButton();
    JPanel pnReplace = new JPanel();
    JLabel lbReplace = new JNPadLabel();
    JComboBox cmbReplace = new JNPadComboBox();
    private Text _text;
    private static final long serialVersionUID = -2710933606343004639L;

    public ReplaceDialog(JNPadFrame jNPad) {
        super(jNPad, SearchBundle.getString("ReplaceDialog.title", new Object[0]));
        try {
            this.jbInit();
            this.pack();
            this.setLocationRelativeTo(jNPad);
            this.setVisible(true);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    private void jbInit() throws Exception {
        this.lbReplace.setText(SearchBundle.getString("ReplaceDialog.replaceWith", new Object[0]));
        this.cmbReplace.setEditable(true);
        this.cmbReplace.getEditor().getEditorComponent().addKeyListener(this.keyHandler);
        this.btReplace.setText(SearchBundle.getString("ReplaceDialog.replace", new Object[0]));
        this.btReplace.addActionListener(this.actionHandler);
        this.btReplaceAll.setText(SearchBundle.getString("ReplaceDialog.replaceAll", new Object[0]));
        this.btReplaceAll.addActionListener(this.actionHandler);
        this.pnButtons.add((Component)this.btFind, null);
        this.pnButtons.add((Component)this.btReplace, null);
        this.pnButtons.add((Component)this.btReplaceAll, null);
        this.pnButtons.add((Component)this.btClose, null);
        this.pnReplace.setLayout(new BorderLayout(5, 5));
        this.pnReplace.add((Component)this.lbReplace, "West");
        this.pnReplace.add((Component)this.cmbReplace, "Center");
        this.pnOptionsN.add((Component)this.pnFind, null);
        this.pnOptionsN.add((Component)this.pnReplace, null);
        this.pnOptionsN.add((Component)this.pnLookIn, null);
        GUIUtilities.setRelativeSize(this.lbFind, this.lbReplace, this.lbLookIn);
        this.loadState();
    }

    @Override
    void loadState() {
        GUIUtilities.setComboBoxList(this.cmbFind, Config.getFindList());
        GUIUtilities.setComboBoxList(this.cmbReplace, Config.getReplaceList());
        int lookIn = Config.REPLACE_LOOKIN.getValue();
        if (lookIn >= 0 && lookIn <= 2) {
            this.cmbLookIn.setSelectedIndex(lookIn);
        }
        this.cbFindFromCursor.setSelected(Config.REPLACE_FROMCURSOR.getValue());
        this.cbMatchCase.setSelected(Config.REPLACE_MATCH_CASE.getValue());
        this.cbMatchWholeWord.setSelected(Config.REPLACE_MATCH_WHOLEWORD.getValue());
        if (Config.REPLACE_DIRECTION_DOWN.getValue().booleanValue()) {
            this.rbFindFoward.setSelected(true);
        } else {
            this.rbFindBackward.setSelected(true);
        }
        if (this._text != null) {
            this._text = null;
        }
    }

    @Override
    void saveState() {
        Config.setFindList(GUIUtilities.getComboBoxList(this.cmbFind));
        Config.setReplaceList(GUIUtilities.getComboBoxList(this.cmbReplace));
        Config.saveSearchHistorial();
        Config.REPLACE_LOOKIN.setValue(this.cmbLookIn.getSelectedIndex());
        Config.REPLACE_FROMCURSOR.setValue(this.cbFindFromCursor.isSelected());
        Config.REPLACE_MATCH_CASE.setValue(this.cbMatchCase.isSelected());
        Config.REPLACE_MATCH_WHOLEWORD.setValue(this.cbMatchWholeWord.isSelected());
        Config.REPLACE_DIRECTION_DOWN.setValue(this.rbFindFoward.isSelected());
    }

    @Override
    boolean initialize(boolean hide) {
        if (Utilities.isEmptyString(this.getSearchFor()) || !this.checkBuffer()) {
            return false;
        }
        GUIUtilities.updateComboBoxList(this.cmbFind);
        GUIUtilities.updateComboBoxList(this.cmbReplace);
        if (hide) {
            this.searchManagerDialog.setMode(11, this.getSearchFor(), this.getReplaceWith());
        }
        this.resetReplace();
        this.saveState();
        if (hide) {
            this.setVisible(false);
        }
        this.resetFind();
        return true;
    }

    String getReplaceWith() {
        return GUIUtilities.getItem(this.cmbReplace);
    }

    @Override
    SearchContext getSearchContext() {
        SearchContext context = new SearchContext(this.getSearchFor(), this.getReplaceWith());
        context.setMatchCase(this.cbMatchCase.isSelected());
        context.setWholeWord(this.cbMatchWholeWord.isSelected());
        context.setSearchForward(this.rbFindFoward.isSelected());
        context.setHighlightAll(false);
        return context;
    }

    @Override
    void removeHighlight(EditPane editPane, SearchContext context) {
        editPane.clearSearchHighlight();
        editPane.clearAllOccurrences();
    }

    @Override
    void resetReplace() {
        this._text = null;
    }

    private void replaceInOpenDocumments() {
        Buffer[] bufferArray = this.jNPad.getViewer().getBuffers();
        int n = bufferArray.length;
        int n2 = 0;
        while (n2 < n) {
            Buffer eview = bufferArray[n2];
            this.resetFind();
            this.resetReplace();
            this.doReplace(eview, true);
            ++n2;
        }
    }

    public void replaceNext() {
        this._buffer = this.jNPad.getActiveBuffer();
        this.doReplaceNext();
    }

    private void doReplaceNext() {
        if (!this.replace(false)) {
            int option = this.reportWordNotFound2();
            if (option == 1 || option == -1) {
                return;
            }
            this.resetFind(true);
            this.doReplace(this._buffer, false);
        }
    }

    @Override
    boolean replace(boolean all) {
        return this.checkBuffer() && this.doReplace(this._buffer, all);
    }

    private char[] getCharText(JNPadTextArea textArea) {
        String text = textArea.getText();
        if (this.cbMatchCase.isSelected()) {
            return text.toCharArray();
        }
        return text.toLowerCase().toCharArray();
    }

    private void adjustMaxPosition(JNPadTextArea textArea) {
        boolean selection;
        boolean bl = selection = this.cmbLookIn.getSelectedIndex() == 2;
        this._maxPosition = selection ? (this._maxPosition += this._text.getContext().getReplaceWith().length() - this._text.getContext().getSearchFor().length()) : textArea.getDocument().getLength() - 1;
        if (this._maxPosition < 0) {
            this._maxPosition = 0;
        }
    }

    private boolean doReplace(Buffer buffer, boolean all) {
        char[] searchForArray;
        char[] searchInArray;
        EditPane editPane = buffer.getSelectedEditPane();
        JNPadTextArea textArea = buffer.getSelectedTextArea();
        SearchContext context = this.getSearchContext();
        this.removeHighlight(editPane, context);
        if (this._text != null) {
            buffer.replace(this._text.getStartPosition(), this._text.getEndPosition(), this._text.getContext().getReplaceWith());
            this.adjustMaxPosition(textArea);
            this._text = null;
        }
        String searchIn = textArea.getText();
        String searchFor = this.getSearchFor();
        if (this.cbMatchCase.isSelected()) {
            searchInArray = searchIn.toCharArray();
            searchForArray = searchFor.toCharArray();
        } else {
            searchInArray = searchIn.toLowerCase().toCharArray();
            searchForArray = searchFor.toLowerCase().toCharArray();
        }
        int count = 0;
        if (all) {
            buffer.beginCompoundEdit();
        }
        int len = searchInArray.length;
        while (this._actualPosition < len && this._actualPosition <= this._maxPosition && this._actualPosition >= this._minPosition) {
            if (searchInArray[this._actualPosition] == searchForArray[0] && this._actualPosition + searchForArray.length - 1 <= this._maxPosition) {
                int endPosition = this._actualPosition + 1;
                int ln = 1;
                while (ln < searchForArray.length && searchInArray[endPosition] == searchForArray[ln]) {
                    ++endPosition;
                    ++ln;
                }
                if (ln == searchForArray.length && this.checkWholeWord(searchInArray, this._actualPosition, ln, this._minPosition, this._maxPosition)) {
                    if (all) {
                        textArea.select(this._actualPosition, endPosition);
                        textArea.replaceSelection(this.getReplaceWith());
                        searchInArray = this.getCharText(textArea);
                        len = searchInArray.length;
                        this.adjustMaxPosition(textArea);
                        ++count;
                    } else {
                        try {
                            editPane.highlightSearch(context, this._actualPosition, endPosition);
                            String line = textArea.getLineTextOfOffset(this._actualPosition);
                            line = Utilities.removeNewLine(line);
                            this._text = new Text(line, context, "", this._actualPosition, endPosition);
                        }
                        catch (BadLocationException ex) {
                            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                        }
                        this._actualPosition += this._inc;
                        return true;
                    }
                }
            }
            this._actualPosition += this._inc;
        }
        if (all) {
            buffer.endCompoundEdit();
            String status = SearchBundle.getString("ReplaceDialog.status.replaceAll", count);
            this.lbStatusBar.setText(status);
        }
        return false;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.lbStatusBar.setText(" ");
            this.cmbFind.requestFocus();
            this._buffer = this.jNPad.getActiveBuffer();
            try {
                if (this._buffer != null) {
                    String selectedText;
                    if (this.cmbLookIn.getSelectedIndex() != 2 && Utilities.isNotEmptyString(selectedText = this._buffer.getSelectedTextArea().getSelectedText())) {
                        this.cmbFind.getEditor().setItem(selectedText);
                        this.cmbFind.getEditor().selectAll();
                    }
                    boolean isEditable = !this._buffer.isReadOnly();
                    this.lbReplace.setEnabled(isEditable);
                    this.cmbReplace.setEnabled(isEditable);
                    this.btReplace.setEnabled(isEditable);
                    this.btReplaceAll.setEnabled(isEditable);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        } else {
            this.saveState();
        }
        super.setVisible(b);
    }

    @Override
    void handleKeyPressed(KeyEvent e) {
        Object obj = e.getSource();
        if (e.getKeyCode() == 10 && obj == this.cmbFind.getEditor().getEditorComponent()) {
            this.actionHandler.actionPerformed(new ActionEvent(this.btReplace, 1001, ""));
        }
    }

    @Override
    void handleActionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.cmbLookIn) {
            int selectedIndex = this.cmbLookIn.getSelectedIndex();
            boolean b = selectedIndex == 0 || selectedIndex == 2;
            this.btFind.setEnabled(b);
            this.btReplace.setEnabled(b && this.checkBuffer() && !this._buffer.isReadOnly());
        } else if (obj == this.btReplace && this.initialize(true)) {
            if (this.replace(false)) {
                this.searchManagerDialog.loadState();
            } else {
                this.reportWordNotFound();
            }
        } else if (obj == this.btReplaceAll && this.initialize(false)) {
            if (this.cmbLookIn.getSelectedIndex() == 1) {
                this.replaceInOpenDocumments();
            } else {
                this.replace(true);
            }
        } else {
            super.handleActionPerformed(e);
        }
    }
}

