/*
 * Decompiled with CFR 0.152.
 */
package jnpad.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jnpad.JNPadFrame;
import jnpad.search.SearchBundle;
import jnpad.search.SearchDialog;
import jnpad.ui.EscapableDialog;
import jnpad.ui.JNPadLabel;
import jnpad.ui.ReporterUtilities;

public class SearchManagerDialog
extends EscapableDialog {
    JPanel contentPane;
    JLabel lbText = new JNPadLabel();
    JPanel pnButtons = new JPanel();
    JButton btPrevious = new JButton();
    JButton btReplace = new JButton();
    JButton btNext = new JButton();
    JButton btOptions = new JButton();
    JButton btCancel = new JButton();
    JButton btAll = new JButton();
    static final int FIND = 10;
    static final int REPLACE = 11;
    private int mode = 10;
    private Point location = null;
    private SearchDialog searchDialog;
    private String searchFor = "";
    private JNPadFrame jNPad;
    private static final Logger LOGGER = Logger.getLogger(SearchManagerDialog.class.getName());
    private static final long serialVersionUID = 8300833753032334654L;

    public SearchManagerDialog(JNPadFrame jNPad, SearchDialog searchDialog) {
        super((Frame)jNPad, true);
        this.jNPad = jNPad;
        this.searchDialog = searchDialog;
        try {
            this.jbInit();
            this.pack();
            if (this.location == null) {
                this.setLocationRelativeTo(jNPad);
                this.location = this.getLocation();
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    private void jbInit() throws Exception {
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add((Component)this.lbText, "Center");
        this.contentPane.add((Component)this.pnButtons, "South");
        this.lbText.setHorizontalAlignment(0);
        this.lbText.setText(" ");
        this.btReplace.setText(SearchBundle.getString("SearchManagerDialog.replace", new Object[0]));
        this.btNext.setText(SearchBundle.getString("SearchManagerDialog.next", new Object[0]));
        this.btPrevious.setText(SearchBundle.getString("SearchManagerDialog.previous", new Object[0]));
        this.btOptions.setText(SearchBundle.getString("SearchManagerDialog.options", new Object[0]));
        this.btCancel.setText(SearchBundle.getString("SearchManagerDialog.cancel", new Object[0]));
        this.btAll.setText(SearchBundle.getString("SearchManagerDialog.all", new Object[0]));
        ActionHandler actionHandler = new ActionHandler();
        this.btOptions.addActionListener(actionHandler);
        this.btReplace.addActionListener(actionHandler);
        this.btNext.addActionListener(actionHandler);
        this.btPrevious.addActionListener(actionHandler);
        this.btCancel.addActionListener(actionHandler);
        this.btAll.addActionListener(actionHandler);
        this.setResizable(false);
    }

    public void setMode(int mode, String searchFor, String replaceWith) {
        this.mode = mode;
        this.searchFor = searchFor;
        this.pnButtons.removeAll();
        if (mode == 10) {
            this.lbText.setText(SearchBundle.getString("SearchManagerDialog.textFind", searchFor));
            this.btNext.requestFocus();
            this.pnButtons.add((Component)this.btPrevious, null);
        } else if (mode == 11) {
            this.lbText.setText(SearchBundle.getString("SearchManagerDialog.textReplace", searchFor, replaceWith));
            this.pnButtons.add((Component)this.btReplace, null);
        }
        this.pnButtons.add((Component)this.btNext, null);
        this.pnButtons.add((Component)this.btAll, null);
        this.pnButtons.add((Component)this.btOptions, null);
        this.pnButtons.add((Component)this.btCancel, null);
        this.pack();
        this.setLocationRelativeTo(this.jNPad);
    }

    @Override
    protected void escapePressed() {
        this.saveState();
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.saveState();
        }
        super.processWindowEvent(e);
    }

    public void saveState() {
        this.location = this.getLocation();
        this.setVisible(false);
    }

    public void loadState() {
        this.setLocation(this.location);
        this.setVisible(true);
    }

    private void normalReplace() {
        if (!this.searchDialog.replace(false)) {
            this.saveState();
            this.reportWordNotFound(true);
        }
    }

    private void reportWordNotFound(boolean next) {
        if (next) {
            ReporterUtilities.reportInfo(this.jNPad, SearchBundle.getString("SearchManagerDialog.notFound.next", this.searchFor));
        } else {
            ReporterUtilities.reportInfo(this.jNPad, SearchBundle.getString("SearchManagerDialog.notFound.previous", this.searchFor));
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object obj = e.getSource();
            if (obj == SearchManagerDialog.this.btCancel) {
                SearchManagerDialog.this.saveState();
            } else if (obj == SearchManagerDialog.this.btOptions) {
                SearchManagerDialog.this.saveState();
                SearchManagerDialog.this.searchDialog.setVisible(true);
            } else if (obj == SearchManagerDialog.this.btReplace) {
                SearchManagerDialog.this.normalReplace();
            } else if (obj == SearchManagerDialog.this.btPrevious) {
                if (!SearchManagerDialog.this.searchDialog.searchPrevious()) {
                    SearchManagerDialog.this.saveState();
                    SearchManagerDialog.this.reportWordNotFound(false);
                }
            } else if (obj == SearchManagerDialog.this.btNext) {
                if (SearchManagerDialog.this.mode == 10) {
                    if (!SearchManagerDialog.this.searchDialog.searchNext()) {
                        SearchManagerDialog.this.saveState();
                        SearchManagerDialog.this.reportWordNotFound(true);
                    }
                } else if (SearchManagerDialog.this.mode == 11) {
                    SearchManagerDialog.this.searchDialog.resetReplace();
                    SearchManagerDialog.this.normalReplace();
                }
            } else if (obj == SearchManagerDialog.this.btAll) {
                SearchManagerDialog.this.saveState();
                SearchManagerDialog.this.searchDialog.resetFind();
                if (SearchManagerDialog.this.mode == 10) {
                    SearchManagerDialog.this.searchDialog.find(true);
                } else if (SearchManagerDialog.this.mode == 11) {
                    SearchManagerDialog.this.searchDialog.resetReplace();
                    SearchManagerDialog.this.searchDialog.replace(true);
                }
            }
        }
    }
}

