/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text;

import java.util.TreeSet;
import java.util.Vector;
import javax.swing.text.BadLocationException;
import jnpad.text.JNPadTextArea;
import jnpad.text.TextUtilities;

final class CompletionUtilities {
    private CompletionUtilities() {
    }

    static String getWord(JNPadTextArea textArea, int offset) throws BadLocationException {
        String line = textArea.getLineTextOfOffset(offset);
        int dot = offset - textArea.getLineStartOffset(textArea.getLineOfOffset(offset));
        if (dot == 0) {
            return null;
        }
        int wordStart = TextUtilities.findWordStart(line, dot - 1, textArea.getDelimiters());
        return line.substring(wordStart, dot);
    }

    static String getWord(String line, int offset, String delimiters) {
        int wordEnd = TextUtilities.findWordEnd(line, offset + 1, delimiters);
        return line.substring(offset, wordEnd);
    }

    static int getDivergentIndex(String str1, String str2) {
        int result = str1.length();
        if (!str1.equals(str2)) {
            result = 0;
            while (result < str1.length() && result < str2.length() && str1.charAt(result) == str2.charAt(result)) {
                ++result;
            }
        }
        return result;
    }

    static void set(JNPadTextArea tp, String word, int wordLen, String delimiters, TreeSet<String> completions) throws BadLocationException {
        int i = 0;
        while (i < tp.getLineCount()) {
            String _word;
            String line = tp.getLineText(i);
            if (line.startsWith(word) && (_word = CompletionUtilities.getWord(line, 0, delimiters)).length() != wordLen) {
                completions.add(_word);
            }
            int len = line.length() - word.length();
            int j = 0;
            while (j < len) {
                String _word2;
                char c = line.charAt(j);
                if (!Character.isLetterOrDigit(c) && delimiters.indexOf(c) == -1 && line.regionMatches(j + 1, word, 0, wordLen) && (_word2 = CompletionUtilities.getWord(line, j + 1, delimiters)).length() != wordLen) {
                    completions.add(_word2);
                }
                ++j;
            }
            ++i;
        }
    }

    static Vector<String> refreshListData(String word, String[] completions) {
        Vector<String> v = new Vector<String>();
        String[] stringArray = completions;
        int n = completions.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item.startsWith(word)) {
                v.add(item);
            }
            ++n2;
        }
        return v;
    }
}

