/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import jnpad.JNPadFrame;

public class JNPadTransferHandler
extends TransferHandler {
    private JTextComponent exportComp;
    private boolean shouldRemove;
    private Position p0 = null;
    private Position p1 = null;
    private JNPadFrame jNPad;
    private static final Logger LOGGER = Logger.getLogger(JNPadTransferHandler.class.getName());
    private static final long serialVersionUID = 1231193598766229947L;

    public JNPadTransferHandler(JNPadFrame jNPad) {
        this.jNPad = jNPad;
    }

    @Override
    public int getSourceActions(JComponent c) {
        if (((JTextComponent)c).isEditable()) {
            return 3;
        }
        return 1;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        this.exportComp = (JTextComponent)c;
        int start = this.exportComp.getSelectionStart();
        int end = this.exportComp.getSelectionEnd();
        Document doc = this.exportComp.getDocument();
        if (start == end) {
            return null;
        }
        try {
            this.p0 = doc.createPosition(start);
            this.p1 = doc.createPosition(end);
        }
        catch (BadLocationException ex) {
            LOGGER.warning("Can't create position - unable to remove text from source.");
        }
        this.shouldRemove = true;
        String data = this.exportComp.getSelectedText();
        return new StringSelection(data);
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        if (this.shouldRemove && action == 2 && this.p0 != null && this.p1 != null && this.p0.getOffset() != this.p1.getOffset()) {
            try {
                JTextComponent tc = (JTextComponent)source;
                tc.getDocument().remove(this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
            }
            catch (BadLocationException e) {
                LOGGER.warning("Can't remove text from source.");
            }
        }
        this.exportComp = null;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] flavors) {
        JTextComponent tc = (JTextComponent)comp;
        return tc.isEditable() && tc.isEnabled() && (this.hasFileFlavor(flavors) || this.hasStringFlavor(flavors));
    }

    private boolean hasFileFlavor(DataFlavor[] flavors) {
        DataFlavor[] dataFlavorArray = flavors;
        int n = flavors.length;
        int n2 = 0;
        while (n2 < n) {
            DataFlavor flavor = dataFlavorArray[n2];
            if (DataFlavor.javaFileListFlavor.equals(flavor)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean hasStringFlavor(DataFlavor[] flavors) {
        DataFlavor[] dataFlavorArray = flavors;
        int n = flavors.length;
        int n2 = 0;
        while (n2 < n) {
            DataFlavor flavor = dataFlavorArray[n2];
            if (DataFlavor.stringFlavor.equals(flavor)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        block8: {
            JTextComponent tc;
            block9: {
                DataFlavor[] flavors;
                block7: {
                    if (!this.canImport(comp, t.getTransferDataFlavors())) {
                        return false;
                    }
                    flavors = t.getTransferDataFlavors();
                    if (!this.hasFileFlavor(flavors)) break block7;
                    List files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                    for (Object file1 : files) {
                        File file = (File)file1;
                        this.jNPad.openFile(file.getAbsolutePath());
                    }
                    return true;
                }
                if (!this.hasStringFlavor(flavors)) break block8;
                tc = (JTextComponent)comp;
                if (!tc.equals(this.exportComp) || tc.getCaretPosition() < this.p0.getOffset() || tc.getCaretPosition() > this.p1.getOffset()) break block9;
                this.shouldRemove = false;
                return true;
            }
            try {
                String str = (String)t.getTransferData(DataFlavor.stringFlavor);
                tc.replaceSelection(str);
                this.jNPad.getActiveEditPane().repaintGutter();
                return true;
            }
            catch (UnsupportedFlavorException ufex) {
                LOGGER.warning("importData: unsupported data flavor");
            }
            catch (IOException ieox) {
                LOGGER.warning("importData: I/O exception");
            }
        }
        return false;
    }
}

