/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text;

import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import jnpad.text.JNPadTextAreaEditorKit;
import jnpad.text.MiniViewerTextArea;
import jnpad.text.syntax.ASN1View;
import jnpad.text.syntax.CPPView;
import jnpad.text.syntax.CView;
import jnpad.text.syntax.ContentTypes;
import jnpad.text.syntax.JavaView;
import jnpad.text.syntax.PlainView2;
import jnpad.text.syntax.PropertiesView;
import jnpad.text.syntax.WrappedPlainView2;

class MiniViewerTextAreaUI
extends BasicTextAreaUI
implements ContentTypes {
    private static final EditorKit defaultKit = new JNPadTextAreaEditorKit();

    MiniViewerTextAreaUI() {
    }

    public static ComponentUI createUI(JComponent ta) {
        return new MiniViewerTextAreaUI();
    }

    @Override
    protected void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getPropertyName().equals("jnpad.contentType")) {
            this.modelChanged();
        }
    }

    @Override
    public View create(Element elem) {
        JTextComponent c = this.getComponent();
        if (c instanceof MiniViewerTextArea) {
            MiniViewerTextArea area = (MiniViewerTextArea)c;
            String style = area.getContentType();
            if ("text/java".equals(style)) {
                return new JavaView(elem, true);
            }
            if ("text/c".equals(style)) {
                return new CView(elem, true);
            }
            if ("text/cpp".equals(style)) {
                return new CPPView(elem, true);
            }
            if ("text/properties".equals(style)) {
                return new PropertiesView(elem, true);
            }
            if ("text/asn1".equals(style)) {
                return new ASN1View(elem, true);
            }
            if ("text/plain".equals(style)) {
                if (area.getLineWrap()) {
                    return new WrappedPlainView2(elem, area.getWrapStyleWord());
                }
                return new PlainView2(elem, true);
            }
        }
        return super.create(elem);
    }

    @Override
    public void installUI(JComponent c) {
        if (!(c instanceof MiniViewerTextArea)) {
            throw new Error("MiniViewerTextAreaUI needs an instance of MiniViewerTextArea!");
        }
        super.installUI(c);
    }

    @Override
    public EditorKit getEditorKit(JTextComponent tc) {
        return defaultKit;
    }
}

