/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import jnpad.config.Config;
import jnpad.config.Configurable;
import jnpad.text.EditPane;
import jnpad.text.MiniViewer;
import jnpad.text.TextBundle;
import jnpad.ui.plaf.LAFUtils;

public class MinimapWindow
extends JWindow
implements Configurable {
    JPanel contentPane;
    MiniViewer miniViewer;
    JPopupMenu popupMenu = new JPopupMenu();
    JCheckBoxMenuItem cbmiShowViewRect = new JCheckBoxMenuItem();
    JMenuItem miCloseMinimap = new JMenuItem();
    private EditPane editPane;
    private static Logger LOGGER = Logger.getLogger(MinimapWindow.class.getName());
    private static final long serialVersionUID = 6762112706921698054L;

    public MinimapWindow(EditPane editPane) {
        super(editPane.buffer.jNPad);
        this.editPane = editPane;
        try {
            this.miniViewer = new MiniViewer(editPane);
            this.jbInit();
            Dimension s = editPane.getSize();
            s.height /= 2;
            this.setSize(s);
            this.setLocation(editPane.getLocationOnScreen());
            this.setVisible(true);
            this.miniViewer.centerViewport();
            if (this.cbmiShowViewRect.isSelected()) {
                this.miniViewer.textArea.adjustViewRect();
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    private void jbInit() throws Exception {
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        Border border = LAFUtils.getToolTipBorder();
        if (border != null) {
            this.contentPane.setBorder(border);
        }
        this.contentPane.add((Component)this.miniViewer, "Center");
        this.miniViewer.textArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    MinimapWindow.this.showPopup(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    MinimapWindow.this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    MinimapWindow.this.showPopup(e);
                }
            }
        });
        this.cbmiShowViewRect.setText(TextBundle.getString("MinimapWindow.showViewRect", new Object[0]));
        this.cbmiShowViewRect.setSelected(Config.MINIMAP_VIEWRECT_VISIBLE.getValue());
        this.miCloseMinimap.setText(TextBundle.getString("MinimapWindow.closeMinimap", new Object[0]));
        this.popupMenu.add(this.cbmiShowViewRect);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.miCloseMinimap);
        this.cbmiShowViewRect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MinimapWindow.this.miniViewer.textArea.setViewRectVisible(MinimapWindow.this.cbmiShowViewRect.isSelected());
                if (MinimapWindow.this.cbmiShowViewRect.isSelected()) {
                    MinimapWindow.this.miniViewer.textArea.adjustViewRect();
                }
                MinimapWindow.this.miniViewer.textArea.repaint();
            }
        });
        this.miCloseMinimap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MinimapWindow)MinimapWindow.this).editPane.tbShowMinimap.setSelected(false);
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MinimapWindow)MinimapWindow.this).editPane.tbShowMinimap.setSelected(false);
            }
        }, "Escape", KeyStroke.getKeyStroke(27, 0), 1);
    }

    private void showPopup(MouseEvent e) {
        this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    void repaintGutter() {
        this.miniViewer.repaintGutter();
    }

    public void setActiveLineVisible(boolean b) {
        this.miniViewer.setActiveLineVisible(b);
    }

    public void setLineNumbersVisible(boolean b) {
        this.miniViewer.setLineNumbersVisible(b);
    }

    @Override
    public void configure(int cfg) {
        this.miniViewer.configure(cfg);
    }
}

