/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text.syntax;

import java.awt.Font;
import java.awt.Graphics;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import jnpad.text.JNPadDocument;
import jnpad.text.syntax.ASN1Scheme;
import jnpad.text.syntax.SyntaxScheme;
import jnpad.text.syntax.SyntaxView;

public class ASN1View
extends SyntaxView {
    ASN1Scheme scheme;

    public ASN1View(Element elem, boolean mini) {
        super(elem, mini);
        this.scheme = !mini ? (ASN1Scheme)((JNPadDocument)this.getDocument()).getScheme() : (ASN1Scheme)((JNPadDocument)this.getDocument()).getMiniScheme();
    }

    @Override
    int doDrawUnselectedText(Graphics g, int x, int y, int start, int length) throws BadLocationException {
        Segment content = new Segment();
        this.getDocument().getText(start, length, content);
        int wordIndex = 0;
        while (wordIndex < content.length()) {
            Font savedFont;
            Segment text;
            char indexedChar = content.charAt(wordIndex);
            if (this.isASN1IdentifierStart(indexedChar)) {
                String scannedIdentifier = this.scanIdentifier(content, wordIndex);
                int scannedIdentifierLength = scannedIdentifier.length();
                text = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedIdentifierLength, text);
                Font savedFont2 = g.getFont();
                ASN1Scheme.WordType type = this.scheme.getWordType(scannedIdentifier);
                g.setColor(this.scheme.getWordColor(type));
                g.setFont(this.scheme.getWordFont(type));
                x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont2);
                wordIndex += scannedIdentifierLength;
                continue;
            }
            if (Character.isDigit(indexedChar)) {
                String scannedNumericLiteral = this.scanNumericLiteral(content, wordIndex);
                int scannedNumericLiteralLength = scannedNumericLiteral.length();
                text = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedNumericLiteralLength, text);
                g.setColor(this.scheme.getNumberColor());
                x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, start + wordIndex);
                wordIndex += scannedNumericLiteralLength;
                continue;
            }
            if (this.isStringDelimiter(indexedChar)) {
                int scannedStringLength = this.scanStringLiteral(content, wordIndex);
                Segment text2 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedStringLength, text2);
                savedFont = g.getFont();
                g.setColor(this.scheme.getStringColor());
                g.setFont(this.scheme.getStringFont());
                x = Utilities.drawTabbedText(text2, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont);
                wordIndex += scannedStringLength;
                continue;
            }
            if (this.isCharDelimiter(indexedChar)) {
                int scannedCharLength = this.scanCharLiteral(content, wordIndex);
                Segment text3 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedCharLength, text3);
                g.setColor(this.scheme.getStringColor());
                g.setFont(this.scheme.getStringFont());
                x = Utilities.drawTabbedText(text3, x, y, g, (TabExpander)this, start + wordIndex);
                wordIndex += scannedCharLength;
                continue;
            }
            if (this.isSingleLineCommentStart(content, wordIndex)) {
                int scannedCommentLength = this.scanSingleLineComment(content, wordIndex);
                Segment text4 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedCommentLength, text4);
                savedFont = g.getFont();
                g.setColor(this.scheme.getCommentColor());
                g.setFont(this.scheme.getCommentFont());
                x = Utilities.drawTabbedText(text4, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont);
                wordIndex += scannedCommentLength;
                continue;
            }
            if (this.isBracket(indexedChar)) {
                Segment text5 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, 1, text5);
                Font savedFont3 = g.getFont();
                g.setFont(this.scheme.getBracketFont());
                g.setColor(this.scheme.getBracketColor());
                x = Utilities.drawTabbedText(text5, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont3);
                ++wordIndex;
                continue;
            }
            if (this.isOperator(indexedChar)) {
                Segment text6 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, 1, text6);
                Font savedFont4 = g.getFont();
                g.setFont(this.scheme.getOperatorFont());
                g.setColor(this.scheme.getOperatorColor());
                x = Utilities.drawTabbedText(text6, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont4);
                ++wordIndex;
                continue;
            }
            Segment text7 = this.getLineBuffer();
            this.getDocument().getText(start + wordIndex, 1, text7);
            g.setColor(this.scheme.getTextColor());
            x = Utilities.drawTabbedText(text7, x, y, g, (TabExpander)this, start + wordIndex);
            ++wordIndex;
        }
        return x;
    }

    @Override
    int doDrawSelectedText(Graphics g, int x, int y, int start, int length) throws BadLocationException {
        Segment content = new Segment();
        this.getDocument().getText(start, length, content);
        g.setColor(this.scheme.getSelectedTextColor());
        int wordIndex = 0;
        while (wordIndex < content.length()) {
            Segment text;
            Font savedFont;
            char indexedChar = content.charAt(wordIndex);
            if (this.isASN1IdentifierStart(indexedChar)) {
                String scannedIdentifier = this.scanIdentifier(content, wordIndex);
                int scannedIdentifierLength = scannedIdentifier.length();
                Segment text2 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedIdentifierLength, text2);
                Font savedFont2 = g.getFont();
                ASN1Scheme.WordType type = this.scheme.getWordType(scannedIdentifier);
                g.setFont(this.scheme.getWordFont(type));
                x = Utilities.drawTabbedText(text2, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont2);
                wordIndex += scannedIdentifierLength;
                continue;
            }
            if (this.isStringDelimiter(indexedChar)) {
                int scannedStringLength = this.scanStringLiteral(content, wordIndex);
                Segment text3 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedStringLength, text3);
                savedFont = g.getFont();
                g.setFont(this.scheme.getStringFont());
                x = Utilities.drawTabbedText(text3, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont);
                wordIndex += scannedStringLength;
                continue;
            }
            if (this.isCharDelimiter(indexedChar)) {
                int scannedCharLength = this.scanCharLiteral(content, wordIndex);
                Segment text4 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedCharLength, text4);
                g.setFont(this.scheme.getStringFont());
                x = Utilities.drawTabbedText(text4, x, y, g, (TabExpander)this, start + wordIndex);
                wordIndex += scannedCharLength;
                continue;
            }
            if (this.isSingleLineCommentStart(content, wordIndex)) {
                int scannedCommentLength = this.scanSingleLineComment(content, wordIndex);
                Segment text5 = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedCommentLength, text5);
                savedFont = g.getFont();
                g.setFont(this.scheme.getCommentFont());
                x = Utilities.drawTabbedText(text5, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont);
                wordIndex += scannedCommentLength;
                continue;
            }
            if (this.isBracket(indexedChar)) {
                text = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, 1, text);
                Font savedFont3 = g.getFont();
                g.setFont(this.scheme.getBracketFont());
                x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont3);
                ++wordIndex;
                continue;
            }
            if (this.isOperator(indexedChar)) {
                text = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, 1, text);
                Font savedFont4 = g.getFont();
                g.setFont(this.scheme.getOperatorFont());
                x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont4);
                ++wordIndex;
                continue;
            }
            text = this.getLineBuffer();
            this.getDocument().getText(start + wordIndex, 1, text);
            x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, start + wordIndex);
            ++wordIndex;
        }
        return x;
    }

    boolean isASN1IdentifierStart(char ch) {
        return Character.isLetter(ch);
    }

    boolean isASN1IdentifierPart(char ch) {
        return Character.isLetterOrDigit(ch) || ch == '-' || ch == '.';
    }

    @Override
    String scanIdentifier(Segment s, int index) {
        String string = new String(s.array, s.offset, s.count);
        int identifierLength = 0;
        if (!this.isASN1IdentifierStart(string.charAt(index))) {
            return "";
        }
        identifierLength = 1;
        while (identifierLength < string.length() - index) {
            if (!this.isASN1IdentifierPart(string.charAt(index + identifierLength))) break;
            ++identifierLength;
        }
        return string.substring(index, index + identifierLength);
    }

    @Override
    boolean isSingleLineCommentStart(Segment s, int index) {
        return s.charAt(index) == '-' && index + 1 < s.length() && s.charAt(index + 1) == '-';
    }

    @Override
    int scanSingleLineComment(Segment s, int index) {
        index += 2;
        int commentLength = 0;
        while (commentLength < s.length() - index) {
            int idx = index + commentLength;
            char commentChar = s.charAt(idx);
            if (commentChar == '\n') break;
            if (commentChar == '-' && idx - 1 >= 0 && s.charAt(idx - 1) == '-') {
                ++commentLength;
                break;
            }
            ++commentLength;
        }
        return commentLength + 2;
    }

    @Override
    SyntaxScheme getScheme() {
        return this.scheme;
    }
}

