/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text.syntax;

import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jnpad.JNPad;
import jnpad.config.Config;
import jnpad.text.syntax.SyntaxScheme;
import jnpad.util.Utilities;

public class CScheme
extends SyntaxScheme {
    static Color additionalColor;
    static Color flowControlColor;
    static Color dataTypeColor;
    static Color dataValueColor;
    static Color constantColor;
    static Color directiveColor;
    Font additionalFont;
    Font flowControlFont;
    Font dataTypeFont;
    Font dataValueFont;
    Font constantFont;
    Font directiveFont;
    static boolean classify;
    private static final char[] OPERATORS;
    static Map<String, WordType> m_specialWords;
    private static final Logger LOGGER;
    private static final long serialVersionUID = 7210306544383499474L;

    static {
        OPERATORS = new char[]{'-', '+', '*', '/', '<', '>', '!', '~', '%', '^', '&', '|', '=', '.', '\\'};
        m_specialWords = new HashMap<String, WordType>();
        LOGGER = Logger.getLogger(CScheme.class.getName());
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.config("C Scheme - init.");
        }
        classify = Config.SYNTAX_CLASSIFY_ENABLED.getValue();
        BufferedReader in = null;
        try {
            try {
                String line;
                String dir = String.valueOf(JNPad.PROPS_DIR) + Utilities.DIR_SEPARATOR + "schemes";
                String file = String.valueOf(dir) + Utilities.DIR_SEPARATOR + "c.words";
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                while ((line = in.readLine()) != null && !line.equals(":KEYWORDS")) {
                }
                while ((line = in.readLine()) != null && !line.equals(":ADDITIONALS")) {
                    CScheme.read(line, WordType.KEYWORD);
                }
                while ((line = in.readLine()) != null && !line.equals(":FLOW_CONTROLS")) {
                    CScheme.read(line, WordType.ADDITIONAL);
                }
                while ((line = in.readLine()) != null && !line.equals(":DATA_TYPES")) {
                    CScheme.read(line, WordType.FLOW_CONTROL);
                }
                while ((line = in.readLine()) != null && !line.equals(":DATA_VALUES")) {
                    CScheme.read(line, WordType.DATA_TYPE);
                }
                while ((line = in.readLine()) != null && !line.equals(":CONSTANTS")) {
                    CScheme.read(line, WordType.DATA_VALUE);
                }
                while ((line = in.readLine()) != null && !line.equals(":DIRECTIVES")) {
                    CScheme.read(line, WordType.CONSTANT);
                }
                while ((line = in.readLine()) != null) {
                    CScheme.read(line, WordType.DIRECTIVE);
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex2) {
                    LOGGER.log(Level.WARNING, ex2.getMessage(), ex2);
                }
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    static void read(String line, WordType type) {
        if (Utilities.isBlankString(line) || line.startsWith("::")) {
            return;
        }
        m_specialWords.put(line.trim(), type);
    }

    public CScheme(boolean mini) {
        super(mini);
        this.doUpdateColors();
        this.doUpdateFonts();
    }

    private void doUpdateColors() {
        classify = Config.SYNTAX_CLASSIFY_ENABLED.getValue();
        additionalColor = Config.SYNTAX_KEYWORD2_COLOR.getValue();
        flowControlColor = Config.SYNTAX_KEYWORD4_COLOR.getValue();
        dataTypeColor = Config.SYNTAX_KEYWORD5_COLOR.getValue();
        dataValueColor = Config.SYNTAX_KEYWORD6_COLOR.getValue();
        constantColor = Config.SYNTAX_KEYWORD8_COLOR.getValue();
        directiveColor = Config.SYNTAX_COMMENT3_COLOR.getValue();
    }

    private void doUpdateFonts() {
        this.additionalFont = this.textFont.deriveFont(Config.SYNTAX_KEYWORD2_STYLE.getValue());
        this.flowControlFont = this.textFont.deriveFont(Config.SYNTAX_KEYWORD4_STYLE.getValue());
        this.dataTypeFont = this.textFont.deriveFont(Config.SYNTAX_KEYWORD5_STYLE.getValue());
        this.dataValueFont = this.textFont.deriveFont(Config.SYNTAX_KEYWORD6_STYLE.getValue());
        this.constantFont = this.textFont.deriveFont(Config.SYNTAX_KEYWORD8_STYLE.getValue());
        this.directiveFont = this.textFont.deriveFont(Config.SYNTAX_COMMENT3_STYLE.getValue());
    }

    @Override
    public void setTextFont(Font f) {
        super.setTextFont(f);
        this.doUpdateFonts();
    }

    @Override
    public void configure(int cfg) {
        super.configure(cfg);
        if ((cfg & 1) != 0) {
            this.doUpdateColors();
        }
        if ((cfg & 2) != 0) {
            this.doUpdateFonts();
        }
    }

    public WordType getWordType(String word) {
        WordType type = m_specialWords.get(word);
        return type != null ? type : WordType.TEXT;
    }

    public Color getWordColor(WordType type) {
        if (type == null) {
            return this.textColor;
        }
        switch (type) {
            case KEYWORD: {
                return keywordColor;
            }
            case DIRECTIVE: {
                return directiveColor;
            }
            case ADDITIONAL: {
                return classify ? additionalColor : keywordColor;
            }
            case FLOW_CONTROL: {
                return classify ? flowControlColor : keywordColor;
            }
            case DATA_TYPE: {
                return classify ? dataTypeColor : keywordColor;
            }
            case DATA_VALUE: {
                return classify ? dataValueColor : keywordColor;
            }
            case CONSTANT: {
                return classify ? constantColor : this.textColor;
            }
        }
        return this.textColor;
    }

    public Font getWordFont(WordType type) {
        if (type == null) {
            return this.textFont;
        }
        switch (type) {
            case KEYWORD: {
                return this.keywordFont;
            }
            case DIRECTIVE: {
                return this.directiveFont;
            }
            case ADDITIONAL: {
                return classify ? this.additionalFont : this.keywordFont;
            }
            case FLOW_CONTROL: {
                return classify ? this.flowControlFont : this.keywordFont;
            }
            case DATA_TYPE: {
                return classify ? this.dataTypeFont : this.keywordFont;
            }
            case DATA_VALUE: {
                return classify ? this.dataValueFont : this.keywordFont;
            }
            case CONSTANT: {
                return classify ? this.constantFont : this.textFont;
            }
        }
        return this.textFont;
    }

    @Override
    public char[] getOperators() {
        return Utilities.copyOf(OPERATORS);
    }

    @Override
    public String getContentType() {
        return "text/c";
    }

    @Override
    public String[] getStartComment() {
        return new String[]{"//"};
    }

    @Override
    public String[] getEndComment() {
        return new String[]{"\n"};
    }

    @Override
    public String[] getStartMultilineComment() {
        return new String[]{"/*"};
    }

    @Override
    public String[] getEndMultilineComment() {
        return new String[]{"*/"};
    }

    static enum WordType {
        KEYWORD,
        ADDITIONAL,
        FLOW_CONTROL,
        DATA_TYPE,
        DATA_VALUE,
        CONSTANT,
        DIRECTIVE,
        MODIFIER,
        EXCEPTION,
        OPERATOR,
        TEXT;

    }
}

