/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text.syntax;

import java.awt.Font;
import java.awt.Graphics;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import jnpad.text.JNPadDocument;
import jnpad.text.syntax.PropertiesScheme;
import jnpad.text.syntax.SyntaxScheme;
import jnpad.text.syntax.SyntaxView;

public class PropertiesView
extends SyntaxView {
    PropertiesScheme scheme;

    public PropertiesView(Element elem, boolean mini) {
        super(elem, mini);
        this.scheme = !mini ? (PropertiesScheme)((JNPadDocument)this.getDocument()).getScheme() : (PropertiesScheme)((JNPadDocument)this.getDocument()).getMiniScheme();
    }

    @Override
    int doDrawUnselectedText(Graphics g, int x, int y, int start, int length) throws BadLocationException {
        Segment content = new Segment();
        this.getDocument().getText(start, length, content);
        int wordIndex = 0;
        while (wordIndex < content.length()) {
            char indexedChar = content.charAt(wordIndex);
            if (this.isSingleLineCommentStart(content, wordIndex)) {
                int scannedCommentLength = this.scanSingleLineComment(content, wordIndex);
                Segment text = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedCommentLength, text);
                Font savedFont = g.getFont();
                g.setColor(this.scheme.getCommentColor());
                g.setFont(this.scheme.getCommentFont());
                x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont);
                wordIndex += scannedCommentLength;
                continue;
            }
            if (this.isOperator(indexedChar)) {
                Segment text = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, 1, text);
                Font savedFont = g.getFont();
                g.setFont(this.scheme.getOperatorFont());
                g.setColor(this.scheme.getOperatorColor());
                x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, start + wordIndex);
                int scannedCommentLength = this.scanSingleLineComment(content, ++wordIndex);
                text = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedCommentLength, text);
                g.setFont(this.scheme.getValueFont());
                g.setColor(this.scheme.getValueColor());
                x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont);
                wordIndex += scannedCommentLength;
                continue;
            }
            Segment text = this.getLineBuffer();
            this.getDocument().getText(start + wordIndex, 1, text);
            g.setColor(this.scheme.getTextColor());
            x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, start + wordIndex);
            ++wordIndex;
        }
        return x;
    }

    @Override
    int doDrawSelectedText(Graphics g, int x, int y, int start, int length) throws BadLocationException {
        Segment content = new Segment();
        this.getDocument().getText(start, length, content);
        g.setColor(this.scheme.getSelectedTextColor());
        int wordIndex = 0;
        while (wordIndex < content.length()) {
            char indexedChar = content.charAt(wordIndex);
            if (this.isSingleLineCommentStart(content, wordIndex)) {
                int scannedCommentLength = this.scanSingleLineComment(content, wordIndex);
                Segment text = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedCommentLength, text);
                Font savedFont = g.getFont();
                g.setFont(this.scheme.getCommentFont());
                x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont);
                wordIndex += scannedCommentLength;
                continue;
            }
            if (this.isOperator(indexedChar)) {
                Segment text = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, 1, text);
                Font savedFont = g.getFont();
                g.setFont(this.scheme.getOperatorFont());
                x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, start + wordIndex);
                int scannedCommentLength = this.scanSingleLineComment(content, ++wordIndex);
                text = this.getLineBuffer();
                this.getDocument().getText(start + wordIndex, scannedCommentLength, text);
                g.setFont(this.scheme.getValueFont());
                x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, start + wordIndex);
                g.setFont(savedFont);
                wordIndex += scannedCommentLength;
                continue;
            }
            Segment text = this.getLineBuffer();
            this.getDocument().getText(start + wordIndex, 1, text);
            x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, start + wordIndex);
            ++wordIndex;
        }
        return x;
    }

    @Override
    boolean isSingleLineCommentStart(Segment s, int index) {
        return s.charAt(index) == '#';
    }

    @Override
    SyntaxScheme getScheme() {
        return this.scheme;
    }
}

