/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import jnpad.GUIUtilities;
import jnpad.ui.GradientPaintable;
import jnpad.ui.JNPadLabel;
import jnpad.ui.Roundable;

public class GradientLabel
extends JNPadLabel
implements GradientPaintable,
Roundable {
    private Color _gradientColor1;
    private Color _gradientColor2;
    private int _orientation = 12;
    private double _arcWidth;
    private double _arcHeight;
    private static final Logger LOGGER = Logger.getLogger(GradientLabel.class.getName());
    private static final long serialVersionUID = -5260830624227212427L;

    public GradientLabel() {
        this("", null, 10);
    }

    public GradientLabel(String text) {
        this(text, null, 10);
    }

    public GradientLabel(String text, int horizontalAlignment) {
        this(text, null, horizontalAlignment);
    }

    public GradientLabel(Icon icon) {
        this(null, icon, 0);
    }

    public GradientLabel(Icon icon, int horizontalAlignment) {
        this(null, icon, horizontalAlignment);
    }

    public GradientLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        this.setOpaque(false);
    }

    public GradientLabel(Color color) {
        this("", null, 10, color, color, 12);
    }

    public GradientLabel(String text, Color color) {
        this(text, null, 10, color, color, 12);
    }

    public GradientLabel(String text, int horizontalAlignment, Color color) {
        this(text, null, horizontalAlignment, color, color, 12);
    }

    public GradientLabel(Icon icon, Color color) {
        this(null, icon, 0, color, color, 12);
    }

    public GradientLabel(Icon icon, int horizontalAlignment, Color color) {
        this(null, icon, horizontalAlignment, color, color, 12);
    }

    public GradientLabel(String text, Icon icon, int horizontalAlignment, Color color) {
        this(text, icon, horizontalAlignment, color, color, 12);
    }

    public GradientLabel(Color color1, Color color2) {
        this("", null, 10, color1, color2, 12);
    }

    public GradientLabel(String text, Color color1, Color color2) {
        this(text, null, 10, color1, color2, 12);
    }

    public GradientLabel(String text, int horizontalAlignment, Color color1, Color color2) {
        this(text, null, horizontalAlignment, color1, color2, 12);
    }

    public GradientLabel(Icon icon, Color color1, Color color2) {
        this(null, icon, 0, color1, color2, 12);
    }

    public GradientLabel(Icon icon, int horizontalAlignment, Color color1, Color color2) {
        this(null, icon, horizontalAlignment, color1, color2, 12);
    }

    public GradientLabel(String text, Icon icon, int horizontalAlignment, Color color1, Color color2) {
        this(text, icon, horizontalAlignment, color1, color2, 12);
    }

    public GradientLabel(String text, Color color1, Color color2, int orientation) {
        this(text, null, 10, color1, color2, orientation);
    }

    public GradientLabel(String text, int horizontalAlignment, Color color1, Color color2, int orientation) {
        this(text, null, horizontalAlignment, color1, color2, orientation);
    }

    public GradientLabel(Icon icon, Color color1, Color color2, int orientation) {
        this(null, icon, 0, color1, color2, orientation);
    }

    public GradientLabel(Icon icon, int horizontalAlignment, Color color1, Color color2, int orientation) {
        this(null, icon, horizontalAlignment, color1, color2, orientation);
    }

    public GradientLabel(String text, Icon icon, int horizontalAlignment, Color color1, Color color2, int orientation) {
        super(text, icon, horizontalAlignment);
        this._orientation = orientation;
        this.setGradientColors(color1, color2);
        this.setOpaque(false);
    }

    @Override
    public Color getGradientColor1() {
        return this._gradientColor1 == null ? this.getBackground() : this._gradientColor1;
    }

    @Override
    public Color getGradientColor2() {
        return this._gradientColor2 == null ? this.getBackground() : this._gradientColor2;
    }

    @Override
    public int getOrientation() {
        return this._orientation;
    }

    @Override
    public void setColor(Color color) {
        this.setGradientColors(color, color);
    }

    @Override
    public void setGradientColor1(Color color1) {
        Color oldGC1 = this._gradientColor1;
        this._gradientColor1 = color1;
        if (oldGC1 != null ? !oldGC1.equals(color1) : color1 != null) {
            this.repaint();
        }
    }

    @Override
    public void setGradientColor2(Color color2) {
        Color oldGC2 = this._gradientColor2;
        this._gradientColor2 = color2;
        if (oldGC2 != null ? !oldGC2.equals(color2) : color2 != null) {
            this.repaint();
        }
    }

    @Override
    public void setGradientColors(Color color1, Color color2) {
        Color oldGC1 = this._gradientColor1;
        Color oldGC2 = this._gradientColor2;
        this._gradientColor1 = color1;
        this._gradientColor2 = color2;
        if (!(oldGC1 != null ? oldGC1.equals(color1) : color1 == null) || (oldGC2 != null ? !oldGC2.equals(color2) : color2 != null)) {
            this.repaint();
        }
    }

    @Override
    public void setOrientation(int orientation) {
        if (!this.supportOrientation(orientation)) {
            return;
        }
        int oldOrientation = this._orientation;
        this._orientation = orientation;
        if (oldOrientation != orientation) {
            this.repaint();
        }
    }

    @Override
    public boolean supportOrientation(int orientation) {
        switch (orientation) {
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    @Override
    public double getArcWidth() {
        return this._arcWidth;
    }

    @Override
    public void setArcWidth(double arcWidth) {
        double oldArcWidth = this._arcWidth;
        this._arcWidth = arcWidth;
        if (oldArcWidth != arcWidth) {
            this.repaint();
        }
    }

    @Override
    public double getArcHeight() {
        return this._arcHeight;
    }

    @Override
    public void setArcHeight(double arcHeight) {
        double oldArcHeight = this._arcHeight;
        this._arcHeight = arcHeight;
        if (oldArcHeight != arcHeight) {
            this.repaint();
        }
    }

    @Override
    public void setArcs(double arcWidth, double arcHeight) {
        double oldArcWidth = this._arcWidth;
        double oldArcHeight = this._arcHeight;
        this._arcWidth = arcWidth;
        this._arcHeight = arcHeight;
        if (oldArcWidth != arcWidth || oldArcHeight != arcHeight) {
            this.repaint();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Dimension d = this.getSize();
        try {
            Graphics2D g2D = (Graphics2D)g;
            Object oldAntialiasing = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            GradientPaint p = GUIUtilities.getGradientPaint(this.getGradientColor1(), this.getGradientColor2(), this._orientation, d);
            g2D.setPaint(p);
            RoundRectangle2D.Double rect = new RoundRectangle2D.Double(0.0, 0.0, d.width, d.height, this._arcWidth, this._arcHeight);
            g2D.fill(rect);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntialiasing);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
        super.paintComponent(g);
    }
}

