/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicMenuUI;
import jnpad.GUIUtilities;
import jnpad.ui.plaf.JNPadLightMetalTheme;
import jnpad.ui.plaf.LAFUtils;

public final class JNPadMenuUI
extends BasicMenuUI {
    private static Color miBg;
    private static Color miFg;
    private static Color borderColor;
    private static Color topLevelMenuBg;

    public static ComponentUI createUI(JComponent x) {
        return new JNPadMenuUI();
    }

    @Override
    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new UMouseInputHandler();
    }

    @Override
    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        if (menuItem instanceof JMenu && ((JMenu)menuItem).isTopLevelMenu()) {
            this.paintTopLevelBackground(g, menuItem, bgColor);
            return;
        }
        if (menuItem.isOpaque()) {
            if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                g.setColor(bgColor);
                g.fillRect(0, 0, menuWidth, menuHeight);
            } else {
                g.setColor(JNPadMenuUI.miBg());
                g.fillRect(0, 0, menuWidth, menuHeight);
            }
            g.setColor(oldColor);
        } else if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
            g.setColor(bgColor);
            g.fillRect(0, 0, menuWidth, menuHeight);
            g.setColor(oldColor);
        }
    }

    protected void paintTopLevelBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        if (model.isRollover() && !model.isSelected()) {
            g.setColor(JNPadMenuUI.topLevelMenuBg());
            g.fillRect(0, 0, menuWidth, menuHeight);
            GUIUtilities.drawBorder(g, JNPadMenuUI.borderColor(), 0, 0, menuWidth, menuHeight);
            g.setColor(oldColor);
        } else if (model.isSelected()) {
            g.setColor(JNPadMenuUI.miBg());
            g.fillRect(0, 0, menuWidth, menuHeight);
            g.setColor(JNPadMenuUI.borderColor());
            this.paintTopLevelSelectedBox(g, menuItem);
            g.setColor(oldColor);
        } else {
            super.paintBackground(g, menuItem, bgColor);
        }
    }

    private void paintTopLevelSelectedBox(Graphics g, JMenuItem menuItem) {
        Point point = this.getPopupMenuOrigin();
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        if (point.getY() >= 0.0) {
            g.drawLine(0, 0, menuWidth - 1, 0);
            g.drawLine(menuWidth - 1, 0, menuWidth - 1, menuHeight - 1);
            g.drawLine(0, 0, 0, menuWidth - 1);
        } else {
            g.drawLine(menuWidth - 1, 0, menuWidth - 1, menuHeight - 1);
            g.drawLine(0, 0, 0, menuWidth - 1);
            g.drawLine(menuWidth - 1, menuHeight - 1, 0, menuHeight - 1);
        }
    }

    protected Point getPopupMenuOrigin() {
        int y;
        int x;
        JMenu menu = (JMenu)this.menuItem;
        JPopupMenu popupMenu = menu.getPopupMenu();
        Dimension dim1 = menu.getSize();
        Dimension dim2 = popupMenu.getSize();
        if (dim2.width == 0) {
            dim2 = popupMenu.getPreferredSize();
        }
        Point point = menu.getLocationOnScreen();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        if (menu.getParent() instanceof JPopupMenu) {
            int mspox = UIManager.getInt("Menu.submenuPopupOffsetX");
            int mspoy = UIManager.getInt("Menu.submenuPopupOffsetY");
            x = dim1.width + mspox;
            if (point.x + x + dim2.width >= dim.width && dim.width - dim1.width < 2 * point.x) {
                x = 0 - mspox - dim2.width;
            }
            if (point.y + (y = mspoy) + dim2.height >= dim.height && dim.height - dim1.height < 2 * point.y) {
                y = dim1.height - mspoy - dim2.height;
            }
        } else {
            int mmpox = UIManager.getInt("Menu.menuPopupOffsetX");
            int mmpoy = UIManager.getInt("Menu.menuPopupOffsetY");
            x = mmpox;
            if (point.x + x + dim2.width >= dim.width && dim.width - dim1.width < 2 * point.x) {
                x = dim1.width - mmpox - dim2.width;
            }
            if (point.y + (y = dim1.height + mmpoy) + dim2.height >= dim.height && dim.height - dim1.height < 2 * point.y) {
                y = 0 - mmpoy - dim2.height;
            }
        }
        return new Point(x, y);
    }

    @Override
    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        ButtonModel model = menuItem.getModel();
        FontMetrics fm = g.getFontMetrics();
        int mnemIndex = menuItem.getDisplayedMnemonicIndex();
        if (!model.isEnabled()) {
            if (UIManager.get("MenuItem.disabledForeground") instanceof Color) {
                g.setColor(UIManager.getColor("MenuItem.disabledForeground"));
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
            } else {
                g.setColor(menuItem.getBackground().brighter());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
                g.setColor(menuItem.getBackground().darker());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x - 1, textRect.y + fm.getAscent() - 1);
            }
        } else {
            if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                if (!((JMenu)menuItem).isTopLevelMenu()) {
                    g.setColor(this.selectionForeground);
                } else {
                    g.setColor(JNPadMenuUI.miFg());
                }
            }
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        JMenu menu = (JMenu)c;
        if (menu.isTopLevelMenu()) {
            menu.setOpaque(false);
        } else {
            this.menuItem.setBorderPainted(false);
            this.menuItem.setOpaque(false);
        }
        super.update(g, c);
    }

    static Color topLevelMenuBg() {
        if (topLevelMenuBg == null) {
            Color color = UIManager.getColor("MenuItem.background");
            topLevelMenuBg = new ColorUIResource(Math.max(color.getRed() - 50, 0), Math.max(color.getGreen() - 50, 0), Math.max(color.getBlue() - 50, 0));
        }
        return topLevelMenuBg;
    }

    private static Color miBg() {
        if (miBg == null) {
            miBg = UIManager.getColor("MenuItem.background");
        }
        return miBg;
    }

    private static Color miFg() {
        if (miBg == null) {
            miFg = UIManager.getColor("MenuItem.foreground");
        }
        return miFg;
    }

    private static Color borderColor() {
        if (borderColor == null) {
            borderColor = LAFUtils.isDarkLAF() ? JNPadLightMetalTheme.GRAY : JNPadLightMetalTheme.DARK_GRAY;
        }
        return borderColor;
    }

    protected class UMouseInputHandler
    extends BasicMenuUI.MouseInputHandler {
        protected UMouseInputHandler() {
            super(JNPadMenuUI.this);
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
            super.mouseEntered(evt);
            JMenu menu = (JMenu)evt.getSource();
            if (menu.isTopLevelMenu()) {
                menu.getModel().setRollover(true);
                JNPadMenuUI.this.menuItem.repaint();
            }
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            super.mouseExited(evt);
            JMenu menu = (JMenu)evt.getSource();
            if (menu.isTopLevelMenu()) {
                menu.getModel().setRollover(false);
                JNPadMenuUI.this.menuItem.repaint();
            }
        }
    }
}

