/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui.plaf;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.plaf.metal.MetalScrollBarUI;
import jnpad.ui.ColorUtilities;
import jnpad.ui.plaf.JNPadScrollButton;

public final class JNPadScrollBarUI
extends MetalScrollBarUI {
    private static Color thumbColor;
    private static Color thumbShadow;
    private static Color thumbHighlightColor;
    private Color highlight;
    private Color shadow;
    private Color a;
    private Color b;
    private Color c;
    private Color d;
    private boolean clicked;

    public static ComponentUI createUI(JComponent c) {
        return new JNPadScrollBarUI();
    }

    @Override
    protected BasicScrollBarUI.TrackListener createTrackListener() {
        return new JNPadTrackListener();
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        this.decreaseButton = new JNPadScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.decreaseButton;
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        this.increaseButton = new JNPadScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.increaseButton;
    }

    @Override
    protected void configureScrollBarColors() {
        super.configureScrollBarColors();
        thumbColor = UIManager.getColor("ScrollBar.thumb");
        thumbShadow = UIManager.getColor("ScrollBar.thumbShadow");
        thumbHighlightColor = UIManager.getColor("ScrollBar.thumbHighlight");
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        Color c2;
        Color c1;
        if (!c.isEnabled()) {
            return;
        }
        g.translate(thumbBounds.x, thumbBounds.y);
        Graphics2D g2D = (Graphics2D)g;
        if (this.clicked) {
            c1 = thumbColor;
            c2 = thumbHighlightColor;
        } else {
            c1 = thumbHighlightColor;
            c2 = thumbColor;
        }
        boolean leftToRight = c.getComponentOrientation().isLeftToRight();
        if (((JScrollBar)c).getOrientation() == 1) {
            if (!this.isFreeStanding) {
                if (!leftToRight) {
                    ++thumbBounds.width;
                    g.translate(-1, 0);
                } else {
                    thumbBounds.width += 2;
                }
            }
            g2D.setPaint(new GradientPaint(0.0f, 0.0f, c1, thumbBounds.width / 2 + 1, 0.0f, c2, true));
            g2D.fillRect(0, 0, thumbBounds.width - 2, thumbBounds.height - 1);
            g.setColor(thumbShadow);
            g.drawRect(0, 0, thumbBounds.width - 2, thumbBounds.height - 1);
            g.setColor(thumbHighlightColor);
            g.drawLine(1, 1, thumbBounds.width - 3, 1);
            g.drawLine(1, 1, 1, thumbBounds.height - 2);
            int i = (int)thumbBounds.getWidth() / 2;
            int k = (int)thumbBounds.getHeight() / 2;
            boolean small = thumbBounds.getHeight() <= 20.0;
            g.setColor(this.a());
            if (!small) {
                g.drawLine(i - 3, k - 8, i + 3, k - 8);
            }
            g.drawLine(i - 3, k - 4, i + 3, k - 4);
            g.drawLine(i - 3, k, i + 3, k);
            g.drawLine(i - 3, k + 4, i + 3, k + 4);
            if (!small) {
                g.drawLine(i - 3, k + 8, i + 3, k + 8);
            }
            g.setColor(this.b());
            if (!small) {
                g.drawLine(i - 2, k - 7, i + 4, k - 7);
            }
            g.drawLine(i - 2, k - 3, i + 4, k - 3);
            g.drawLine(i - 2, k + 1, i + 4, k + 1);
            g.drawLine(i - 2, k + 5, i + 4, k + 5);
            if (!small) {
                g.drawLine(i - 2, k + 9, i + 4, k + 9);
            }
            if (!this.isFreeStanding) {
                if (!leftToRight) {
                    --thumbBounds.width;
                    g.translate(1, 0);
                } else {
                    thumbBounds.width -= 2;
                }
            }
        } else {
            if (!this.isFreeStanding) {
                thumbBounds.height += 2;
            }
            g2D.setPaint(new GradientPaint(0.0f, 0.0f, c1, 0.0f, thumbBounds.height / 2 + 1, c2, true));
            g2D.fillRect(0, 0, thumbBounds.width - 1, thumbBounds.height - 2);
            g.setColor(thumbShadow);
            g.drawRect(0, 0, thumbBounds.width - 1, thumbBounds.height - 2);
            g.setColor(thumbHighlightColor);
            g.drawLine(1, 1, thumbBounds.width - 3, 1);
            g.drawLine(1, 1, 1, thumbBounds.height - 3);
            int j = (int)thumbBounds.getWidth() / 2;
            int l = (int)thumbBounds.getHeight() / 2;
            boolean small = thumbBounds.getWidth() <= 20.0;
            g.setColor(this.c());
            if (!small) {
                g.drawLine(j - 8, l - 3, j - 8, l + 3);
            }
            g.drawLine(j - 4, l - 3, j - 4, l + 3);
            g.drawLine(j, l - 3, j, l + 3);
            g.drawLine(j + 4, l - 3, j + 4, l + 3);
            if (!small) {
                g.drawLine(j + 8, l - 3, j + 8, l + 3);
            }
            g.setColor(this.d());
            if (!small) {
                g.drawLine(j - 7, l - 2, j - 7, l + 4);
            }
            g.drawLine(j - 3, l - 2, j - 3, l + 4);
            g.drawLine(j + 1, l - 2, j + 1, l + 4);
            g.drawLine(j + 5, l - 2, j + 5, l + 4);
            if (!small) {
                g.drawLine(j + 9, l - 2, j + 9, l + 4);
            }
            if (!this.isFreeStanding) {
                thumbBounds.height -= 2;
            }
        }
        g.translate(-thumbBounds.x, -thumbBounds.y);
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        super.paintTrack(g, c, trackBounds);
        Graphics2D g2D = (Graphics2D)g;
        GradientPaint grad = this.scrollbar.getOrientation() == 0 ? new GradientPaint(trackBounds.x, trackBounds.y, this.shadow(), trackBounds.x, trackBounds.y + trackBounds.height, this.highlight()) : new GradientPaint(trackBounds.x, trackBounds.y, this.shadow(), trackBounds.x + trackBounds.width, trackBounds.y, this.highlight());
        g2D.setPaint(grad);
        g2D.fill(trackBounds);
    }

    private Color highlight() {
        if (this.highlight == null) {
            this.highlight = ColorUtilities.withAlpha(this.trackHighlightColor, 64);
        }
        return this.highlight;
    }

    private Color shadow() {
        if (this.shadow == null) {
            this.shadow = ColorUtilities.withAlpha(this.trackColor, 64);
        }
        return this.shadow;
    }

    private Color a() {
        if (this.a == null) {
            this.a = ColorUtilities.withAlpha(thumbShadow, 150);
        }
        return this.a;
    }

    private Color b() {
        if (this.b == null) {
            this.b = ColorUtilities.withAlpha(thumbHighlightColor, 150);
        }
        return this.b;
    }

    private Color c() {
        if (this.c == null) {
            this.c = ColorUtilities.withAlpha(thumbShadow, 200);
        }
        return this.c;
    }

    private Color d() {
        if (this.d == null) {
            this.d = ColorUtilities.withAlpha(thumbHighlightColor, 200);
        }
        return this.d;
    }

    protected class JNPadTrackListener
    extends BasicScrollBarUI.TrackListener {
        protected JNPadTrackListener() {
            super(JNPadScrollBarUI.this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            JNPadScrollBarUI.this.clicked = true;
            JNPadScrollBarUI.this.scrollbar.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            JNPadScrollBarUI.this.clicked = false;
            JNPadScrollBarUI.this.scrollbar.repaint();
        }
    }
}

