/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui.plaf;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalScrollButton;
import jnpad.GUIUtilities;
import jnpad.ui.ColorUtilities;

public final class JNPadScrollButton
extends MetalScrollButton {
    private Color highlight;
    private Color shadow;
    private static final long serialVersionUID = -1797233002398952045L;

    public JNPadScrollButton(int direction, int width, boolean freeStanding) {
        super(direction, width, freeStanding);
    }

    @Override
    public void paint(Graphics g) {
        GradientPaint grad;
        super.paint(g);
        Rectangle rec = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        switch (this.getDirection()) {
            case 3: 
            case 7: {
                grad = GUIUtilities.getGradientPaint(this.highlight(), this.shadow(), 1, rec.x, rec.y, rec.width, rec.height);
                break;
            }
            default: {
                grad = GUIUtilities.getGradientPaint(this.highlight(), this.shadow(), 0, rec.x, rec.y, rec.width, rec.height);
            }
        }
        Graphics2D g2D = (Graphics2D)g;
        g2D.setPaint(grad);
        g2D.fillRect(rec.x, rec.y, rec.width, rec.height);
    }

    private Color highlight() {
        if (this.highlight == null) {
            this.highlight = ColorUtilities.withAlpha(ColorUtilities.getColor_1_3(MetalLookAndFeel.getControlHighlight(), Color.WHITE), 64);
        }
        return this.highlight;
    }

    private Color shadow() {
        if (this.shadow == null) {
            this.shadow = ColorUtilities.withAlpha(ColorUtilities.getColor_1_3(MetalLookAndFeel.getControlDarkShadow(), Color.BLACK), 64);
        }
        return this.shadow;
    }
}

