/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui.table;

import java.awt.Component;
import javax.swing.AbstractListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.table.JTableHeader;
import jnpad.ui.plaf.LAFUtils;
import jnpad.ui.table.JNPadTable;
import jnpad.util.Utilities;

public class DefaultRowHeader
extends JList {
    private static final long serialVersionUID = 9171731729489674053L;

    public DefaultRowHeader(JNPadTable table) {
        super(new RowHeaderListModel(table));
        this.setFixedCellWidth(table.getRowHeaderWidth());
        this.setFixedCellHeight(table.getRowHeight());
        this.setCellRenderer(new RowHeaderListCellRenderer(table));
    }

    static class RowHeaderListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = -8250433421952735476L;
        private JNPadTable table;

        RowHeaderListCellRenderer(JNPadTable table) {
            this.table = table;
            JTableHeader header = table.getTableHeader();
            this.setOpaque(true);
            this.setBorder(LAFUtils.getTableHeaderCellBorder());
            this.setHorizontalAlignment(0);
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JTableHeader header = this.table.getTableHeader();
            this.setHorizontalAlignment(0);
            this.setFont(header.getFont());
            if (index == this.table.getRowHeaderSelected()) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setForeground(header.getForeground());
                this.setBackground(header.getBackground());
            }
            this.setBorder(LAFUtils.getTableHeaderCellBorder());
            this.setText(Utilities.toString(value));
            return this;
        }
    }

    static class RowHeaderListModel
    extends AbstractListModel {
        private static final long serialVersionUID = 5464969185300876705L;
        private JNPadTable table;

        RowHeaderListModel(JNPadTable table) {
            this.table = table;
        }

        @Override
        public int getSize() {
            return this.table.getRowCount();
        }

        @Override
        public Object getElementAt(int index) {
            return String.valueOf(index + 1);
        }
    }
}

