/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui.toolbar;

import java.awt.GridLayout;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import jnpad.ui.toolbar.ToolBoxButton;
import jnpad.ui.toolbar.ToolBoxToggleButton;

class PopupToolBox
extends JToolBar {
    private List<AbstractButton> l_buttons = new ArrayList<AbstractButton>();
    private MouseListener _mouseListener;
    private int _rows;
    private int _cols;
    private static final long serialVersionUID = -260339599596718508L;

    public PopupToolBox(int rows, int cols, boolean rollover) {
        this.setRollover(rollover);
        this._rows = rows;
        this._cols = cols;
        this.setLayout(new GridLayout(this._rows, this._cols));
        this.setFloatable(false);
    }

    public AbstractButton add(AbstractButton button) {
        AbstractButton toolbutton = button instanceof JButton ? new ToolBoxButton((JButton)button) : (button instanceof JToggleButton ? new ToolBoxToggleButton((JToggleButton)button) : button);
        super.add(toolbutton);
        this.l_buttons.add(toolbutton);
        return toolbutton;
    }

    public void setButtonMouseListener(MouseListener mouseListener) {
        this._mouseListener = mouseListener;
    }

    public void rebuild() {
        super.removeAll();
        this.setLayout(new GridLayout(this._rows, this._cols));
        for (AbstractButton button : this.l_buttons) {
            super.add(button);
            if (this._mouseListener == null) continue;
            button.addMouseListener(this._mouseListener);
        }
    }
}

