/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.action;

import java.awt.event.ItemEvent;

import jnpad.GUIUtilities;
import jnpad.JNPadFrame;
import jnpad.action.JNPadActions.Group;
import jnpad.config.Accelerators;
import jnpad.config.Config;
import jnpad.text.Buffer;
import jnpad.text.IEditAction;
import jnpad.ui.MnemonicHelper;
import jnpad.ui.status.StatusDisplayable;
import jnpad.util.LineSeparator;

/**
 * The Class SelectEOLAction.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public abstract class SelectEOLAction extends JNPadAction implements IEditAction {
  private LineSeparator         lineSeparator;

  private static MnemonicHelper mnemonicHelper   = new MnemonicHelper();

  /** UID */
  private static final long     serialVersionUID = -7911049330691224084L;

  /**
   * Instantiates a new select EOL action.
   *
   * @param jNPad the jNPad's frame
   * @param name String
   * @param lineSeparator LineSeparator
   * @param picture String
   */
  protected SelectEOLAction(JNPadFrame jNPad, String name, LineSeparator lineSeparator, String picture) {
    super(jNPad, name, Group.CONFIGURE);
    
    this.lineSeparator = lineSeparator;

    setLabel(lineSeparator.getLongName());

    char mnemonic = mnemonicHelper.getMnemonic(getLabel());
    if (mnemonic != 0) {
      setMnemonic(mnemonic);
    }
    
    if (Config.isDefaultMode()) {
      setIcon(GUIUtilities.loadIcon(picture));
    }

    if (Accelerators.isUsingCompositeShortcuts()) {
      setKeyBinding(Accelerators.getShortcutLabel(name));
    }
    
    setDescription(ActionBundle.getString("select-eol.description", getLabel())); //$NON-NLS-1$
    setStateAction(true);
  }

  /**
   * Handle state changed.
   *
   * @param e the ItemEvent
   * @see jnpad.action.JNPadAction#handleStateChanged(java.awt.event.ItemEvent)
   */
  @Override
  public void handleStateChanged(final ItemEvent e) {
    Buffer buffer = jNPad.getActiveBuffer();
    if (buffer != null && ItemEvent.SELECTED == e.getStateChange()) {
      buffer.setLineSeparator(lineSeparator);
      jNPad.setStatus(ActionBundle.getString("select-eol.message", lineSeparator.getName()), StatusDisplayable.TIMEOUT_DEFAULT); //$NON-NLS-1$
    }
  }

}
