/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.action;

import static jnpad.action.JNPadActions.ACTION_NAME_WORD_COUNT;

import javax.swing.JOptionPane;

import jnpad.JNPadFrame;
import jnpad.action.JNPadActions.Group;
import jnpad.config.Accelerators;
import jnpad.text.EditPane;
import jnpad.text.JNPadTextArea;
import jnpad.util.Utilities;

/**
 * The Class WordCountAction.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public final class WordCountAction extends JNPadAction {
  /** UID */
  private static final long serialVersionUID = -9168815841017327401L;

  /**
   * Instantiates a new word count action.
   *
   * @param jNPad the jNPad's frame
   */
  public WordCountAction(JNPadFrame jNPad) {
    super(jNPad,
          ACTION_NAME_WORD_COUNT,
          Group.EDIT,
          Accelerators.WORD_COUNT, null);
  }

  /**
   * Perform action.
   *
   * @see jnpad.action.JNPadAction#performAction()
   */
  @Override
  public void performAction() {
    EditPane editPane = jNPad.getActiveEditPane();

    if (editPane != null) {
      JNPadTextArea textArea = editPane.getTextArea();
      
      String text = textArea.getText();
      String selectedText;

      int start = textArea.getSelectionStart();
      int end = textArea.getCaretPosition();
      if (end < start) {
        start ^= end;
        end = start ^ end;
        start ^= end;
      }
      if (start != end) {
        if (end > text.length()) {
          end--;
        }
        if (end < 0) {
          end = 0;
        }
        selectedText = text.substring(start, end);
      }
      else {
        selectedText = text;
      }

      int lines = 1, words = 0;
      boolean word = false;
      int characters = selectedText.length();

      for (int i = 0; i < selectedText.length(); i++) {
        switch (selectedText.charAt(i)) {
          case Utilities.LF:
            lines++;
            //$FALL-THROUGH$
          case Utilities.SPACE:
          case Utilities.TAB:
            if (word) {
              words++;
              word = false;
            }
            break;
          default:
            word = true;
            if (i == selectedText.length() - 1) {
              words++;
            }
            break;
        }
      }

      Object[] args = {
          ActionBundle.getString(ACTION_NAME_WORD_COUNT.concat(".words"), words), //$NON-NLS-1$
          ActionBundle.getString(ACTION_NAME_WORD_COUNT.concat(".characters"), characters), //$NON-NLS-1$
          ActionBundle.getString(ACTION_NAME_WORD_COUNT.concat(".lines"), lines)}; //$NON-NLS-1$

      JOptionPane.showMessageDialog(jNPad,
                                    args,
                                    ActionBundle.getString(ACTION_NAME_WORD_COUNT.concat(".message")), //$NON-NLS-1$
                                    JOptionPane.INFORMATION_MESSAGE);

    }
  }

}
