/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.config;

/**
 * The Class FloatProp.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public class FloatProp extends Prop<Float> {
  /** UID */
  private static final long serialVersionUID = -2845155650100465556L;

  /**
   * Instantiates a new float prop.
   *
   * @param name the name
   * @param def the def
   */
  public FloatProp(String name, float def) {
    super(name, def);
  }

  /**
   * Gets the default string.
   *
   * @return the default string
   * @see jnpad.config.Prop#getDefaultString()
   */
  @Override
  public String getDefaultString() {
    return format(defaultValue);
  }

  /**
   * Parses the.
   *
   * @param value the value
   * @return the float
   * @throws NumberFormatException the number format exception
   */
  public static float parse(String value) throws NumberFormatException {
    return Float.parseFloat(value);
  }

  /**
   * Format.
   *
   * @param value the value
   * @return the string
   */
  public static String format(float value) {
    return Float.toString(value);
  }

  /**
   * Gets the value.
   *
   * @return the value
   * @see jnpad.config.Prop#getValue()
   */
  @Override
  public Float getValue() {
    return Config.getFloatProp(this);
  }

  /**
   * Do set value.
   *
   * @param value the value
   * @see jnpad.config.Prop#doSetValue(java.lang.Object)
   */
  @Override
  protected void doSetValue(Float value) {
    Config.setFloatProp(this, value);
  }
  
}
