/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.search;

import java.awt.Color;
import java.awt.Component;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;

import jnpad.GUIUtilities;
import jnpad.config.Config;
import jnpad.ui.JNPadTreeCellRenderer;
import jnpad.ui.plaf.LAFUtils;

/**
 * The Class FindResultsTreeCellRenderer.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public class FindResultsTreeCellRenderer extends JLabel implements JNPadTreeCellRenderer {
  /** The selection foreground. */
  private Color               selectionForeground;
  
  /** The text foreground. */
  private Color               textForeground;
  
  /** The selection background. */
  private Color               selectionBackground;
  
  /** The text background. */
  private Color               textBackground;

  /** The ii root. */
  private static ImageIcon    iiRoot;
  
  /** The ii elem. */
  private static ImageIcon    iiElem;

  static {
    try {
      iiRoot = GUIUtilities.getIcon("find.png"); //$NON-NLS-1$
      iiElem = GUIUtilities.getIcon("find-elem.png"); //$NON-NLS-1$
    }
    catch (Exception e) {
      System.out.println(e.toString());
    }
  }

  /** The Constant DEFAULT_NO_FOCUS_BORDER. */
  private static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);

  /** UID. */
  private static final long   serialVersionUID        = 1322228929869523533L;

  /**
   * Instantiates a new find results tree cell renderer.
   */
  public FindResultsTreeCellRenderer() {
    configure(CFG_COLOR);
    setOpaque(true);
    setBorder(DEFAULT_NO_FOCUS_BORDER);
  }

  /**
   * Configure.
   *
   * @param cfg the cfg
   * @see jnpad.config.Configurable#configure(int)
   */
  @Override
  public void configure(final int cfg) {
    if ( (cfg & CFG_COLOR) != 0) {
      selectionForeground = Config.TEXT_SELECTION_FOREGROUND.getValue();
      textForeground      = Config.TEXT_FOREGROUND.getValue();
      textBackground      = Config.TEXT_BACKGROUND.getValue();
      selectionBackground = Config.TEXT_SELECTION_BACKGROUND.getValue();
    }
  }

  /**
   * Gets the tree cell renderer component.
   *
   * @param tree the tree
   * @param value the value
   * @param isSelected is selected
   * @param isExpanded is expanded
   * @param isLeaf is leaf
   * @param row the row
   * @param hasFocus has focus
   * @return the tree cell renderer component
   * @see javax.swing.tree.TreeCellRenderer#getTreeCellRendererComponent(javax.swing.JTree, java.lang.Object, boolean, boolean, boolean, int, boolean)
   */
  @Override
  public Component getTreeCellRendererComponent(JTree tree,
                                                Object value,
                                                boolean isSelected,
                                                boolean isExpanded,
                                                boolean isLeaf,
                                                int row,
                                                boolean hasFocus) {

    setComponentOrientation(tree.getComponentOrientation());

    setForeground(isSelected ? selectionForeground : textForeground);

    if (LAFUtils.isNimbusLAF()) {
      if (isSelected) {
        setOpaque(true);
        setBackground(selectionBackground);
      }
      else {
        setOpaque(false);
      }
    }
    else {
      setOpaque(true);
      setBackground(isSelected ? selectionBackground : textBackground);
    }

    DefaultMutableTreeNode node = (DefaultMutableTreeNode) value;
    Object obj = node.getUserObject();

    setIcon(obj instanceof Text ? iiElem : iiRoot);
    setText(value.toString());
    setEnabled(tree.isEnabled());
    setFont(tree.getFont());
    setBorder( (hasFocus && !LAFUtils.isFullRowSelectionLAF())
              ? LAFUtils.getListFocusCellHighlightBorder()
              : DEFAULT_NO_FOCUS_BORDER);

    return this;
  }

}
