/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.text;

import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingConstants;

import jnpad.action.ActionManager;
import jnpad.action.JNPadActions;
import jnpad.config.Config;
import jnpad.config.Controlable;
import jnpad.ui.icon.ArrowIcon;
import jnpad.ui.plaf.LAFUtils;

/**
 * The Class GutterBase.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public class GutterBase extends JPanel implements Controlable {
  JButton                   btPreviousBookmark = new JButton();
  JButton                   btNextBookmark     = new JButton();

  EditPane                  editPane;

  /** UID */
  private static final long serialVersionUID   = 9112739617599765904L;

  /**
   * Instantiates a new gutter base.
   *
   * @param editPane the edit pane
   */
  public GutterBase(EditPane editPane) {
    super(new GridLayout(0, 2));
    
    this.editPane = editPane;

    btPreviousBookmark.setToolTipText(TextBundle.getString("GutterBase.previousBookmark")); //$NON-NLS-1$
    btPreviousBookmark.setIcon(new ArrowIcon(SwingConstants.NORTH));
    btPreviousBookmark.setMargin(LAFUtils.isNimbusLAF() ? new Insets(0, -7, 0, -7) : new Insets(0, 0, 0, 0));
    btPreviousBookmark.setRequestFocusEnabled(false);
    btPreviousBookmark.setEnabled(false);
    btPreviousBookmark.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(final ActionEvent e) {
        GutterBase.this.editPane.previousBookmark();
      }
    });

    btNextBookmark.setToolTipText(TextBundle.getString("GutterBase.nextBookmark")); //$NON-NLS-1$
    btNextBookmark.setIcon(new ArrowIcon(SwingConstants.SOUTH));
    btNextBookmark.setMargin(LAFUtils.isNimbusLAF() ? new Insets(0, -7, 0, -7) : new Insets(0, 0, 0, 0));
    btNextBookmark.setRequestFocusEnabled(false);
    btNextBookmark.setEnabled(false);
    btNextBookmark.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(final ActionEvent e) {
        GutterBase.this.editPane.nextBookmark();
      }
    });

    add(btPreviousBookmark);
    add(btNextBookmark);

    configure(CFG_COLOR);
  }

  /**
   * Configure.
   *
   * @param cfg the cfg
   * @see jnpad.config.Configurable#configure(int)
   */
  @Override
  public void configure(final int cfg) {
    if ((cfg & CFG_COLOR) != 0) {
      setBackground(Config.GUTTER_BACKGROUND.getValue());
    }
  }

  /**
   * Update controls.
   *
   * @see jnpad.config.Updatable#updateControls()
   */
  @Override
  public void updateControls() {
    updateControls(CTRLS_ALL);
  }

  /**
   * Update controls.
   *
   * @param ctrls the ctrls
   * @see jnpad.config.Updatable#updateControls(int)
   */
  @Override
  public void updateControls(final int ctrls) {
    if ( (ctrls & CTRLS_BOOKMARKING) != 0) {
      boolean b = editPane.hasBookmarks();
      ActionManager.INSTANCE.setEnabled(JNPadActions.ACTION_NAME_NEXT_BOOKMARK, b);
      ActionManager.INSTANCE.setEnabled(JNPadActions.ACTION_NAME_PREVIOUS_BOOKMARK, b);
      ActionManager.INSTANCE.setEnabled(JNPadActions.ACTION_NAME_CLEAR_ALL_BOOKMARKS, b);
      btNextBookmark.setEnabled(b);
      btPreviousBookmark.setEnabled(b);
    }
  }

}
