/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.text.syntax;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Shape;

import javax.swing.text.Element;
import javax.swing.text.WrappedPlainView;

import jnpad.GUIUtilities;
import jnpad.text.AbstractTextArea;

/**
 * The Class WrappedPlainView2.
 * 
 * @version 0.3
 * @since jNPad 0.1
 */
public class WrappedPlainView2 extends WrappedPlainView {
  /** The current font. */
  private Font          currentFont;

  /** Metrics of the current font. */
  protected FontMetrics metrics;

  /**
   * Instantiates a new wrapped plain view2.
   * 
   * @param elem the elem
   */
  public WrappedPlainView2(Element elem) {
    super(elem);
  }

  /**
   * Instantiates a new wrapped plain view2.
   * 
   * @param elem the elem
   * @param wordWrap the word wrap
   */
  public WrappedPlainView2(Element elem, boolean wordWrap) {
    super(elem, wordWrap);
  }

  /**
   * Paint.
   * 
   * @param g the Graphics
   * @param a the Shape
   * @see javax.swing.text.WrappedPlainView#paint(java.awt.Graphics,
   *      java.awt.Shape)
   */
  @Override
  public void paint(Graphics g, Shape a) {
    GUIUtilities.setRenderingHints(g);
    AbstractTextArea host = (AbstractTextArea) getContainer(); // [changed v0.3]
    if (host.isRightMarginLineVisible()) {
      checkMetrics();
      int fontWidth = metrics.charWidth('m');
      int margin = host.getRightMarginLineWidth() * fontWidth;
      g.setColor(host.getRightMarginLineColor());
      g.drawLine(margin + 1, 0, margin + 1, host.getHeight());
    }
    super.paint(g, a);
  }

  /**
   * Check metrics.
   */
  protected void checkMetrics() {
    Component host = getContainer();
    Font f = host.getFont();
    if (currentFont != f) {
      currentFont = f;
      metrics = getContainer().getFontMetrics(currentFont);
    }
  }

}
