/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.ui;

import java.awt.Color;

/**
 * The Interface GradientPaintable.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public interface GradientPaintable extends Orientable {
  /**
   * Gets the gradient color1.
   *
   * @return the gradient color1
   */
  Color getGradientColor1();

  /**
   * Gets the gradient color2.
   *
   * @return the gradient color2
   */
  Color getGradientColor2();

  /**
   * Sets the color.
   *
   * @param color the new color
   */
  void setColor(Color color);

  /**
   * Sets the gradient color1.
   *
   * @param color1 the new gradient color1
   */
  void setGradientColor1(Color color1);

  /**
   * Sets the gradient color2.
   *
   * @param color2 the new gradient color2
   */
  void setGradientColor2(Color color2);

  /**
   * Sets the gradient colors.
   *
   * @param color1 the color1
   * @param color2 the color2
   */
  void setGradientColors(Color color1, Color color2);
}
