/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.ui;

import java.awt.Graphics;
import java.util.Vector;

import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;

import jnpad.GUIUtilities;

/**
 * 
 * @version 0.3
 * @since   jNPad v0.1
 */
public class JNPadComboBox extends JComboBox {
  /** UID */
  private static final long serialVersionUID = 5133408969039688301L;

  /**
   * 
   */
  public JNPadComboBox() {
    super();
  }

  /**
   * Instantiates a new jNPad's combo box.
   *
   * @param aModel the a model
   */
  public JNPadComboBox(ComboBoxModel aModel) {
    super(aModel);
  }

  /**
   * Instantiates a new jNPad's combo box.
   *
   * @param items the items
   */
  public JNPadComboBox(Object[] items) {
    super(items);
  }

  /**
   * Instantiates a new jNPad's combo box.
   *
   * @param items the items
   */
  public JNPadComboBox(Vector<?> items) {
    super(items);
  }

  /**
   * 
   * @param g Graphics
   */
  @Override
  protected void paintComponent(Graphics g) {
    GUIUtilities.setRenderingHints(g);
    super.paintComponent(g);
  }
  
}
