/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.ui;

import javax.swing.JScrollPane;

import jnpad.config.Config;

/**
 * The Class JNPadScrollPane.
 * 
 * @version 0.3
 * @since jNPad 0.1
 */
public class JNPadScrollPane extends JScrollPane {
  /** UID */
  private static final long serialVersionUID = -8187579351580846706L;

  /**
   * Instantiates a new jNPad's scroll pane.
   */
  public JNPadScrollPane() {
    setBorder(null);
    if (Config.isDistractionFreeMode()) {
      setHorizontalScrollBarPolicy(HORIZONTAL_SCROLLBAR_NEVER);
      setVerticalScrollBarPolicy(VERTICAL_SCROLLBAR_NEVER);
    }
    else {
      setHorizontalScrollBarPolicy(HORIZONTAL_SCROLLBAR_ALWAYS);
      setVerticalScrollBarPolicy(VERTICAL_SCROLLBAR_AS_NEEDED);
    }

  }

}
