/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.ui.plaf;

import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLabelUI;

import jnpad.GUIUtilities;

/**
 * The Class JNPadLabelUI.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public final class JNPadLabelUI extends MetalLabelUI {
  /** The Constant INSTANCE. */
  private static final JNPadLabelUI INSTANCE = new JNPadLabelUI();

  /**
   * 
   * @param c JComponent
   * @return ComponentUI
   */
  public static ComponentUI createUI(JComponent c) {
    return INSTANCE;
  }

  /**
   * 
   * @param l JLabel
   * @param g String
   * @param s String
   * @param textX int
   * @param textY int 
   * @see javax.swing.plaf.basic.BasicLabelUI#paintEnabledText(javax.swing.JLabel, java.awt.Graphics, java.lang.String, int, int)
   */
  @Override
  protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
    GUIUtilities.setRenderingHints(g);
    super.paintEnabledText(l, g, s, textX, textY);
  }

  /**
   * 
   * @param l JLabel
   * @param g Graphics
   * @param s String
   * @param textX int
   * @param textY int 
   * @see javax.swing.plaf.metal.MetalLabelUI#paintDisabledText(javax.swing.JLabel, java.awt.Graphics, java.lang.String, int, int)
   */
  @Override
  protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY) {
    GUIUtilities.setRenderingHints(g);
    super.paintDisabledText(l, g, s, textX, textY);
  }

}
