/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.ui.plaf;

import java.awt.Font;
import java.awt.Toolkit;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.plaf.metal.DefaultMetalTheme;

import jnpad.GUIUtilities;
import jnpad.ui.Gray;
import jnpad.util.Platform;

/**
 * The Class JNPadLightMetalTheme.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
@SuppressWarnings("all")
public final class JNPadLightMetalTheme extends DefaultMetalTheme {
  private static final ColorUIResource PRIMARY1     = new ColorUIResource(10, 36, 106);
  private static final ColorUIResource PRIMARY2     = new ColorUIResource(91, 135, 206);
  private static final ColorUIResource PRIMARY3     = new ColorUIResource(166, 202, 240);

  private static final ColorUIResource SECONDARY2   = new ColorUIResource(189, 182, 172);

  static final ColorUIResource         BLACK        = new ColorUIResource(Gray._0);
  static final ColorUIResource         DARK_GRAY    = new ColorUIResource(Gray._64);
  static final ColorUIResource         GRAY         = new ColorUIResource(Gray._128);
  static final ColorUIResource         LIGHT_GRAY_0 = new ColorUIResource(Gray._160);
  static final ColorUIResource         LIGHT_GRAY_1 = new ColorUIResource(Gray._192);
  static final ColorUIResource         LIGHT_GRAY_2 = new ColorUIResource(Gray._229);
  static final ColorUIResource         LIGHT_GRAY_3 = new ColorUIResource(Gray._244);
  static final ColorUIResource         WHITE        = new ColorUIResource(Gray._255);

  static final ColorUIResource         DARK_BLUE    = new ColorUIResource(82, 108, 164);

  private static final FontUIResource  PLAIN_FONT, BOLD_FONT;

  static {
    label0: {
      if (Platform.isWindows) {
        Font font = (Font) Toolkit.getDefaultToolkit().getDesktopProperty("win.messagebox.font"); //$NON-NLS-1$
        if (font != null) {
          PLAIN_FONT = new FontUIResource(font.getName(), Font.PLAIN, font.getSize());
          BOLD_FONT = new FontUIResource(font.getName(), Font.BOLD, font.getSize());
          break label0;
        }
      }
      PLAIN_FONT = new FontUIResource("Dialog", Font.PLAIN, 12); //$NON-NLS-1$
      BOLD_FONT = new FontUIResource("Dialog", Font.BOLD, 12); //$NON-NLS-1$
    }
  }

  /** Logger */
  private final static Logger          LOGGER       = Logger.getLogger(JNPadLightMetalTheme.class.getName());

  @Override public String getName() {return "jNPad (Light)";} //$NON-NLS-1$

  @Override protected ColorUIResource getPrimary1() {return PRIMARY1;}
  @Override protected ColorUIResource getPrimary2() {return PRIMARY2;}
  @Override protected ColorUIResource getPrimary3() {return PRIMARY3;}

  @Override protected ColorUIResource getSecondary2() { return SECONDARY2; }

  @Override public ColorUIResource getControl() {return LIGHT_GRAY_2;}

  @Override public ColorUIResource getSeparatorBackground() {return WHITE;}
  @Override public ColorUIResource getSeparatorForeground() {return GRAY;}

  @Override public ColorUIResource getMenuBackground()         {return LIGHT_GRAY_2;}
  @Override public ColorUIResource getMenuSelectedBackground() {return DARK_BLUE;}
  @Override public ColorUIResource getMenuSelectedForeground() {return WHITE;}

  @Override public ColorUIResource getAcceleratorSelectedForeground() {return WHITE;}

  @Override public FontUIResource getControlTextFont() {return PLAIN_FONT;}
  @Override public FontUIResource getMenuTextFont()    {return PLAIN_FONT;}
  @Override public FontUIResource getSystemTextFont()  {return PLAIN_FONT;}
  @Override public FontUIResource getUserTextFont()    {return PLAIN_FONT;}
  @Override public FontUIResource getWindowTitleFont() {return BOLD_FONT ;}

  /**
   * Adds the custom entries to table.
   *
   * @param table the table
   * @see javax.swing.plaf.metal.MetalTheme#addCustomEntriesToTable(javax.swing.UIDefaults)
   */
  @Override
  public void addCustomEntriesToTable(UIDefaults table) {
    try {
      Object[] defaults = new Object[] {
		"jnpad.dark.theme"              , Boolean.FALSE                                     ,

		"FileChooser.upFolderIcon"      , GUIUtilities.getIcon("plaf/upFolder.png")         ,
		"FileChooser.newFolderIcon"     , GUIUtilities.getIcon("plaf/newFolder.png")        ,
		"FileChooser.homeFolderIcon"    , GUIUtilities.getIcon("plaf/homeFolder.png")       ,
		"FileChooser.listViewIcon"      , GUIUtilities.getIcon("plaf/listView.png")         ,
		"FileChooser.detailsViewIcon"   , GUIUtilities.getIcon("plaf/detailsView.png")      ,

		"OptionPane.errorIcon"          , GUIUtilities.getIcon("plaf/errorDialog.png")      ,
		"OptionPane.informationIcon"    , GUIUtilities.getIcon("plaf/informationDialog.png"),
		"OptionPane.warningIcon"        , GUIUtilities.getIcon("plaf/warningDialog.png")    ,
		"OptionPane.questionIcon"       , GUIUtilities.getIcon("plaf/questionDialog.png")   ,

		"LabelUI"                       , JNPadLabelUI.class.getName()                      ,
		"ButtonUI"                      , JNPadButtonUI.class.getName()                     ,
		"ToggleButtonUI"                , JNPadToggleButtonUI.class.getName()               ,
		"ToolBarUI"                     , JNPadToolBarUI.class.getName()                    ,
		"ToolBarSeparatorUI"            , JNPadToolbarSeparatorUI.class.getName()           ,

		"SplitPaneUI"                   , BasicSplitPaneUI.class.getName()                  ,
		//"SplitPane.dividerSize"       , 3                                                 ,

		"ScrollBarUI"                   , JNPadScrollBarUI.class.getName()                  ,
		"ScrollBar.track"               , getControlShadow()                                ,
		"ScrollBar.trackHighlight"      , getControl()                                      ,
		"ScrollBar.thumb"               , LIGHT_GRAY_1                                      ,
		"ScrollBar.thumbHighlight"      , LIGHT_GRAY_2                                      ,
		"ScrollBar.thumbDarkShadow"     , BLACK                                             ,
		"ScrollBar.thumbShadow"         , GRAY                                              ,

		//"TabbedPaneUI"                , JNPadTabbedPaneUI.class.getName()                 ,
		"TabbedPane.selected"           , LIGHT_GRAY_3                                      ,

		"MenuUI"                        , JNPadMenuUI.class.getName()                       ,

		"PopupMenu.background"          , WHITE                                             ,
		"MenuItem.background"           , WHITE                                             ,
		"RadioButtonMenuItem.background", WHITE                                             ,
		"CheckBoxMenuItem.background"   , WHITE                                             ,

		"TitledBorder.titleColor"       , PRIMARY1                                          ,

		"ToolTip.background"            , new ColorUIResource(255, 255, 231)                ,
      };
      table.putDefaults(defaults);
    }
    catch (Exception ex) {
      LOGGER.log(Level.WARNING, ex.getMessage(), ex);
    }
  }

}
