/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.ui.table;

import java.awt.Component;

import javax.swing.AbstractListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.table.JTableHeader;

import jnpad.ui.plaf.LAFUtils;
import jnpad.util.Utilities;

/**
 * The Class DefaultRowHeader.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public class DefaultRowHeader extends JList {
  /** UID */
  private static final long serialVersionUID = 9171731729489674053L;

  /**
   * Instantiates a new default row header.
   *
   * @param table UTable
   */
  public DefaultRowHeader(JNPadTable table) {
    super(new RowHeaderListModel(table));
    setFixedCellWidth(table.getRowHeaderWidth());
    setFixedCellHeight(table.getRowHeight()
                       // + table.getRowMargin()
                       // + table.getIntercellSpacing().height
                       );
    setCellRenderer(new RowHeaderListCellRenderer(table));
  }

  ////////////////////////////////////////////////////////////////////////////
  /**
   * The Class RowHeaderListModel.
   */
  static class RowHeaderListModel extends AbstractListModel {
    /** UID */
    private static final long serialVersionUID = 5464969185300876705L;

    private JNPadTable table;

    /**
     * Instantiates a new row header list model.
     *
     * @param table UTable
     */
    RowHeaderListModel(JNPadTable table) {
      this.table = table;
    }

    /**
     * Gets the size.
     *
     * @return int
     */
    public int getSize() {
      return table.getRowCount();
    }

    /**
     * Gets the element at.
     *
     * @param index int
     * @return Object
     */
    public Object getElementAt(int index) {
      return String.valueOf(index + 1);
    }
  }
  ////////////////////////////////////////////////////////////////////////////

  ////////////////////////////////////////////////////////////////////////////
  /**
   * The Class RowHeaderListCellRenderer.
   */
  static class RowHeaderListCellRenderer extends JLabel implements ListCellRenderer {
    /** UID */
    private static final long serialVersionUID = -8250433421952735476L;

    private JNPadTable table;

    /**
     * Instantiates a new row header list cell renderer.
     *
     * @param table UTable
     */
    RowHeaderListCellRenderer(JNPadTable table) {
      this.table = table;
      JTableHeader header = table.getTableHeader();
      setOpaque(true);
      setBorder(LAFUtils.getTableHeaderCellBorder());
      setHorizontalAlignment(CENTER);
      setForeground(header.getForeground());
      setBackground(header.getBackground());
      setFont(header.getFont());
    }

    /**
     * Gets the list cell renderer component.
     *
     * @param list the list
     * @param value the value
     * @param index the index
     * @param isSelected selected
     * @param cellHasFocus the cell has focus
     * @return the list cell renderer component
     * @see javax.swing.ListCellRenderer#getListCellRendererComponent(javax.swing.JList, java.lang.Object, int, boolean, boolean)
     */
    @Override
    public Component getListCellRendererComponent(JList list,
                                                  Object value,
                                                  int index,
                                                  boolean isSelected,
                                                  boolean cellHasFocus) {
      JTableHeader header = table.getTableHeader();
      setHorizontalAlignment(CENTER);
      setFont(header.getFont());
      if(index == table.getRowHeaderSelected()) {
        setBackground(list.getSelectionBackground());
        setForeground(list.getSelectionForeground());
      }
      else {
        setForeground(header.getForeground());
        setBackground(header.getBackground());
      }
      setBorder(LAFUtils.getTableHeaderCellBorder());
      setText(Utilities.toString(value));
      return this;
    }
  }
  ////////////////////////////////////////////////////////////////////////////
}
